%% Generated by lilypond-book.py
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}





% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "marking-notes-of-spoken-parts-with-a-cross-on-the-stem.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it is automatically
%% generated from LSR http://lsr.dsi.unimi.it
%% Make any changes in LSR itself, or in Documentation/snippets/new/ ,
%% and then run scripts/auxiliar/makelsr.py
%%
%% This file is in the public domain.
\version "2.16.0"

\header {
%% Translation of GIT committish: cc3b9e1430f4cc9c54da7252e504f3d274a7ea17
  texidocfr = "
Voici comment ajouter une croix aux hampes.  Le début du fragment parlé
est stipulé par une commande @code{\\speakOn}, et la fin par une
commande @code{\\speakOff}.

"
  doctitlefr = "Adjonction d'une croix sur la hampe des notes d'un fragment parlé"

  lsrtags = "contemporary-notation, editorial-annotations, vocal-music, workaround"

  texidoc = "
This example shows how to put crosses on stems.  Mark the beginning of
a spoken section with the @code{\\speakOn} keyword, and end it with the
@code{\\speakOff} keyword.

"
  doctitle = "Marking notes of spoken parts with a cross on the stem"
} % begin verbatim


speakOn = {
  \override Stem #'stencil =
    #(lambda (grob)
       (let* ((x-parent (ly:grob-parent grob X))
              (is-rest? (ly:grob? (ly:grob-object x-parent 'rest))))
         (if is-rest?
             empty-stencil
             (ly:stencil-combine-at-edge
              (ly:stem::print grob)
              Y
              (- (ly:grob-property grob 'direction))
              (grob-interpret-markup grob
                                     (markup #:center-align #:fontsize -4
                                             #:musicglyph "noteheads.s2cross"))
              -2.3))))
}

speakOff = {
  \revert Stem #'stencil
  \revert Flag #'stencil
}

\score {
  \new Staff {
    \relative c'' {
      a4 b a c
      \speakOn
      g4 f r g
      b4 r d e
      \speakOff
      c4 a g f
    }
  }
}



% ****************************************************************
% end ly snippet
% ****************************************************************
