%% Generated by lilypond-book.py
%% Options: [indent=0\mm,verbatim,doctitle,alt=[image of music],texidoc,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section 
% ****************************************************************



\paper {
  #(define dump-extents #t)
  
  indent = 0\mm
  line-width = 160\mm
  force-assignment = #""
  line-width = #(- line-width (* mm  3.000000))
}

\layout {
  
}



% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "letter-tablature-formatting.ly"
\sourcefileline 0
%% Do not edit this file; it is auto-generated from input/new
%% This file is in the public domain.
\version "2.11.64"

\header {
  lsrtags = "staff-notation,fretted-strings"

  texidoc = "Tablature can be formatted using letters instead of
numbers."
  doctitle = "Letter tablature formatting"
} % begin verbatim


#(define (letter-tablature-format str context event)
  (let*
      ((tuning (ly:context-property context 'stringTunings))
       (pitch (ly:event-property event 'pitch)))
    (make-whiteout-markup
     (make-vcenter-markup
      (string (integer->char
         (+ (char->integer #\a)
            (- (ly:pitch-semitones pitch)
            (list-ref tuning (- str 1))))))))))

music = \relative c {
  c4 d e f
  g4 a b c
  d4 e f g
}

<<
  \new Staff {
    \clef "G_8"
    \music
  }
  \new TabStaff \with { 
    tablatureFormat = #letter-tablature-format
  }
  {
    \music
  }
>>



% ****************************************************************
% end ly snippet
% ****************************************************************
