/*
 * Copyright (c) 2003, 2007-14 Matteo Frigo
 * Copyright (c) 2003, 2007-14 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sex Out 30 16:35:57 CET 2015 */

#include "codelet-rdft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_r2cb.native -fma -reorder-insns -schedule-for-pipeline -compact -variables 4 -pipeline-latency 4 -sign 1 -n 128 -name r2cb_128 -include r2cb.h */

/*
 * This function contains 956 FP additions, 540 FP multiplications,
 * (or, 416 additions, 0 multiplications, 540 fused multiply/add),
 * 242 stack variables, 36 constants, and 256 memory accesses
 */
#include "r2cb.h"

static void r2cb_128(R *R0, R *R1, R *Cr, R *Ci, stride rs, stride csr, stride csi, INT v, INT ivs, INT ovs)
{
     DK(KP1_715457220, +1.715457220000544139804539968569540274084981599);
     DK(KP1_606415062, +1.606415062961289819613353025926283847759138854);
     DK(KP599376933, +0.599376933681923766271389869014404232837890546);
     DK(KP741650546, +0.741650546272035369581266691172079863842265220);
     DK(KP1_978353019, +1.978353019929561946903347476032486127967379067);
     DK(KP1_940062506, +1.940062506389087985207968414572200502913731924);
     DK(KP148335987, +0.148335987538347428753676511486911367000625355);
     DK(KP250486960, +0.250486960191305461595702160124721208578685568);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP1_807978586, +1.807978586246886663172400594461074097420264050);
     DK(KP1_481902250, +1.481902250709918182351233794990325459457910619);
     DK(KP472964775, +0.472964775891319928124438237972992463904131113);
     DK(KP906347169, +0.906347169019147157946142717268914412664134293);
     DK(KP1_997590912, +1.997590912410344785429543209518201388886407229);
     DK(KP1_883088130, +1.883088130366041556825018805199004714371179592);
     DK(KP049126849, +0.049126849769467254105343321271313617079695752);
     DK(KP357805721, +0.357805721314524104672487743774474392487532769);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP1_763842528, +1.763842528696710059425513727320776699016885241);
     DK(KP1_913880671, +1.913880671464417729871595773960539938965698411);
     DK(KP534511135, +0.534511135950791641089685961295362908582039528);
     DK(KP303346683, +0.303346683607342391675883946941299872384187453);
     DK(KP1_662939224, +1.662939224605090474157576755235811513477121624);
     DK(KP668178637, +0.668178637919298919997757686523080761552472251);
     DK(KP1_990369453, +1.990369453344393772489673906218959843150949737);
     DK(KP1_546020906, +1.546020906725473921621813219516939601942082586);
     DK(KP098491403, +0.098491403357164253077197521291327432293052451);
     DK(KP820678790, +0.820678790828660330972281985331011598767386482);
     DK(KP1_961570560, +1.961570560806460898252364472268478073947867462);
     DK(KP198912367, +0.198912367379658006911597622644676228597850501);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP1_847759065, +1.847759065022573512256366378793576573644833252);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     DK(KP414213562, +0.414213562373095048801688724209698078569671875);
     DK(KP1_414213562, +1.414213562373095048801688724209698078569671875);
     DK(KP2_000000000, +2.000000000000000000000000000000000000000000000);
     {
	  INT i;
	  for (i = v; i > 0; i = i - 1, R0 = R0 + ovs, R1 = R1 + ovs, Cr = Cr + ivs, Ci = Ci + ivs, MAKE_VOLATILE_STRIDE(512, rs), MAKE_VOLATILE_STRIDE(512, csr), MAKE_VOLATILE_STRIDE(512, csi)) {
	       E T9H, T9I, T9X, T9Y;
	       {
		    E Tdr, T9, Tcl, Ta9, T6b, T2d, T91, T7j, Tg, Tds, Tcm, Tae, T92, T7m, T6c;
		    E T2o, Tdu, Tw, Tco, Tap, TeM, Tdx, T6f, T2G, T6e, T2P, T94, T7t, Tcp, Tak;
		    E T95, T7q, TdM, T1i, TcL, TbD, Tf0, Te6, T6q, T42, T6B, T5t, T9r, T8j, TcA;
		    E TaY, T9g, T7S, TdA, TM, Tcv, TaN, TeP, TdI, T6i, T38, T6l, T3F, T9b, T7J;
		    E Tcs, Taw, T98, T7y, T1N, TeW, T6x, T4H, Te8, TdV, T6w, T4Q, T9j, T86, TcO;
		    E TcI, T9k, T83, TbI, Tbl, T22, TeV, Te0, Te9, T58, T6u, T6t, T5h, T9m, T8d;
		    E TcP, TcF, T9n, T8a, TbJ, Tbw, Te3, T1x, TcB, TbG, Tf1, TdP, T6C, T4p, T6r;
		    E T5w, T9h, T8m, TcM, Tb9, T9s, T7Z, TaB, TaG, TdF, T11, Tct, TaQ, TeQ, TdD;
		    E T6m, T3v, T7B, T7E, T6j, T3I, T99, T7M;
		    {
			 E TaU, TaX, T7Q, T7R, Tbk, Tbf;
			 {
			      E Td, T2e, Tc, Tab, T2m, Te, T2f, T2g;
			      {
				   E T7h, T27, T2c, T7i;
				   {
					E T4, T26, T29, T25, T3, T28, T8, T2a;
					T4 = Cr[WS(csr, 32)];
					T26 = Ci[WS(csi, 32)];
					{
					     E T1, T2, T6, T7;
					     T1 = Cr[0];
					     T2 = Cr[WS(csr, 64)];
					     T6 = Cr[WS(csr, 16)];
					     T7 = Cr[WS(csr, 48)];
					     T29 = Ci[WS(csi, 16)];
					     T25 = T1 - T2;
					     T3 = T1 + T2;
					     T28 = T6 - T7;
					     T8 = T6 + T7;
					     T2a = Ci[WS(csi, 48)];
					}
					{
					     E Ta7, T5, Ta8, T2b;
					     Ta7 = FNMS(KP2_000000000, T4, T3);
					     T5 = FMA(KP2_000000000, T4, T3);
					     T7h = FMA(KP2_000000000, T26, T25);
					     T27 = FNMS(KP2_000000000, T26, T25);
					     Ta8 = T29 - T2a;
					     T2b = T29 + T2a;
					     Tdr = FNMS(KP2_000000000, T8, T5);
					     T9 = FMA(KP2_000000000, T8, T5);
					     Tcl = FMA(KP2_000000000, Ta8, Ta7);
					     Ta9 = FNMS(KP2_000000000, Ta8, Ta7);
					     T2c = T28 - T2b;
					     T7i = T28 + T2b;
					}
				   }
				   {
					E Ta, Tb, T2k, T2l;
					Ta = Cr[WS(csr, 8)];
					T6b = FNMS(KP1_414213562, T2c, T27);
					T2d = FMA(KP1_414213562, T2c, T27);
					T91 = FMA(KP1_414213562, T7i, T7h);
					T7j = FNMS(KP1_414213562, T7i, T7h);
					Tb = Cr[WS(csr, 56)];
					T2k = Ci[WS(csi, 8)];
					T2l = Ci[WS(csi, 56)];
					Td = Cr[WS(csr, 40)];
					T2e = Ta - Tb;
					Tc = Ta + Tb;
					Tab = T2k - T2l;
					T2m = T2k + T2l;
					Te = Cr[WS(csr, 24)];
					T2f = Ci[WS(csi, 40)];
					T2g = Ci[WS(csi, 24)];
				   }
			      }
			      {
				   E Tag, Taj, T7o, T7p;
				   {
					E T2q, Tk, Tam, T2K, T2H, Tn, Tan, T2t, Tu, Tah, T2E, T2N, Tr, T2v, T2y;
					E Tai;
					{
					     E Tl, Tm, T2r, T2s;
					     {
						  E Ti, Tj, T2j, Tf, T2I, T2J;
						  Ti = Cr[WS(csr, 4)];
						  T2j = Td - Te;
						  Tf = Td + Te;
						  {
						       E Tac, T2h, T7k, T2n;
						       Tac = T2f - T2g;
						       T2h = T2f + T2g;
						       T7k = T2m - T2j;
						       T2n = T2j + T2m;
						       {
							    E Taa, Tad, T7l, T2i;
							    Taa = Tc - Tf;
							    Tg = Tc + Tf;
							    Tad = Tab - Tac;
							    Tds = Tac + Tab;
							    T7l = T2e + T2h;
							    T2i = T2e - T2h;
							    Tcm = Taa + Tad;
							    Tae = Taa - Tad;
							    T92 = FMA(KP414213562, T7k, T7l);
							    T7m = FNMS(KP414213562, T7l, T7k);
							    T6c = FMA(KP414213562, T2i, T2n);
							    T2o = FNMS(KP414213562, T2n, T2i);
							    Tj = Cr[WS(csr, 60)];
						       }
						  }
						  T2I = Ci[WS(csi, 4)];
						  T2J = Ci[WS(csi, 60)];
						  Tl = Cr[WS(csr, 36)];
						  T2q = Ti - Tj;
						  Tk = Ti + Tj;
						  Tam = T2I - T2J;
						  T2K = T2I + T2J;
						  Tm = Cr[WS(csr, 28)];
					     }
					     T2r = Ci[WS(csi, 36)];
					     T2s = Ci[WS(csi, 28)];
					     {
						  E Ts, Tt, T2B, T2C;
						  Ts = Cr[WS(csr, 12)];
						  T2H = Tl - Tm;
						  Tn = Tl + Tm;
						  Tan = T2r - T2s;
						  T2t = T2r + T2s;
						  Tt = Cr[WS(csr, 52)];
						  T2B = Ci[WS(csi, 12)];
						  T2C = Ci[WS(csi, 52)];
						  {
						       E Tp, T2A, T2D, Tq, T2w, T2x;
						       Tp = Cr[WS(csr, 20)];
						       Tu = Ts + Tt;
						       T2A = Ts - Tt;
						       Tah = T2C - T2B;
						       T2D = T2B + T2C;
						       Tq = Cr[WS(csr, 44)];
						       T2w = Ci[WS(csi, 20)];
						       T2x = Ci[WS(csi, 44)];
						       T2E = T2A - T2D;
						       T2N = T2A + T2D;
						       Tr = Tp + Tq;
						       T2v = Tp - Tq;
						       T2y = T2w + T2x;
						       Tai = T2w - T2x;
						  }
					     }
					}
					{
					     E T2M, Tdv, Tdw, T2u, T2F, T7s, T7r, T2L, T2O;
					     {
						  E To, T2z, Tv, Tal, Tao;
						  Tag = Tk - Tn;
						  To = Tk + Tn;
						  T2M = T2v + T2y;
						  T2z = T2v - T2y;
						  Tv = Tr + Tu;
						  Tal = Tr - Tu;
						  Tao = Tam - Tan;
						  Tdv = Tan + Tam;
						  Tdu = To - Tv;
						  Tw = To + Tv;
						  Tco = Tao - Tal;
						  Tap = Tal + Tao;
						  Tdw = Tai + Tah;
						  Taj = Tah - Tai;
						  T7o = T2q + T2t;
						  T2u = T2q - T2t;
						  T2F = T2z + T2E;
						  T7s = T2E - T2z;
					     }
					     T7r = T2K - T2H;
					     T2L = T2H + T2K;
					     TeM = Tdw + Tdv;
					     Tdx = Tdv - Tdw;
					     T6f = FNMS(KP707106781, T2F, T2u);
					     T2G = FMA(KP707106781, T2F, T2u);
					     T2O = T2M - T2N;
					     T7p = T2M + T2N;
					     T6e = FNMS(KP707106781, T2O, T2L);
					     T2P = FMA(KP707106781, T2O, T2L);
					     T94 = FMA(KP707106781, T7s, T7r);
					     T7t = FNMS(KP707106781, T7s, T7r);
					}
				   }
				   {
					E T3M, T16, TbA, T5o, T5l, T19, TbB, T3P, T1g, TaV, T40, T5r, T1d, T3R, T3U;
					E TaW;
					{
					     E T17, T18, T3N, T3O;
					     {
						  E T14, T15, T5m, T5n;
						  T14 = Cr[WS(csr, 1)];
						  Tcp = Tag - Taj;
						  Tak = Tag + Taj;
						  T95 = FMA(KP707106781, T7p, T7o);
						  T7q = FNMS(KP707106781, T7p, T7o);
						  T15 = Cr[WS(csr, 63)];
						  T5m = Ci[WS(csi, 1)];
						  T5n = Ci[WS(csi, 63)];
						  T17 = Cr[WS(csr, 33)];
						  T3M = T14 - T15;
						  T16 = T14 + T15;
						  TbA = T5m - T5n;
						  T5o = T5m + T5n;
						  T18 = Cr[WS(csr, 31)];
					     }
					     T3N = Ci[WS(csi, 33)];
					     T3O = Ci[WS(csi, 31)];
					     {
						  E T1e, T1f, T3X, T3Y;
						  T1e = Cr[WS(csr, 15)];
						  T5l = T17 - T18;
						  T19 = T17 + T18;
						  TbB = T3N - T3O;
						  T3P = T3N + T3O;
						  T1f = Cr[WS(csr, 49)];
						  T3X = Ci[WS(csi, 15)];
						  T3Y = Ci[WS(csi, 49)];
						  {
						       E T1b, T3W, T3Z, T1c, T3S, T3T;
						       T1b = Cr[WS(csr, 17)];
						       T1g = T1e + T1f;
						       T3W = T1e - T1f;
						       TaV = T3Y - T3X;
						       T3Z = T3X + T3Y;
						       T1c = Cr[WS(csr, 47)];
						       T3S = Ci[WS(csi, 17)];
						       T3T = Ci[WS(csi, 47)];
						       T40 = T3W - T3Z;
						       T5r = T3W + T3Z;
						       T1d = T1b + T1c;
						       T3R = T1b - T1c;
						       T3U = T3S + T3T;
						       TaW = T3S - T3T;
						  }
					     }
					}
					{
					     E T5q, Te4, Te5, T3Q, T41, T8i, T8h, T5p, T5s;
					     {
						  E T1a, T3V, T1h, Tbz, TbC;
						  TaU = T16 - T19;
						  T1a = T16 + T19;
						  T5q = T3R + T3U;
						  T3V = T3R - T3U;
						  T1h = T1d + T1g;
						  Tbz = T1d - T1g;
						  TbC = TbA - TbB;
						  Te4 = TbB + TbA;
						  TdM = T1a - T1h;
						  T1i = T1a + T1h;
						  TcL = TbC - Tbz;
						  TbD = Tbz + TbC;
						  Te5 = TaW + TaV;
						  TaX = TaV - TaW;
						  T7Q = T3M + T3P;
						  T3Q = T3M - T3P;
						  T41 = T3V + T40;
						  T8i = T40 - T3V;
					     }
					     T8h = T5o - T5l;
					     T5p = T5l + T5o;
					     Tf0 = Te5 + Te4;
					     Te6 = Te4 - Te5;
					     T6q = FNMS(KP707106781, T41, T3Q);
					     T42 = FMA(KP707106781, T41, T3Q);
					     T5s = T5q - T5r;
					     T7R = T5q + T5r;
					     T6B = FNMS(KP707106781, T5s, T5p);
					     T5t = FMA(KP707106781, T5s, T5p);
					     T9r = FMA(KP707106781, T8i, T8h);
					     T8j = FNMS(KP707106781, T8i, T8h);
					}
				   }
			      }
			 }
			 {
			      E Tas, Tav, T7w, T7x;
			      {
				   E T2S, TA, TaK, T3A, T3x, TD, TaL, T2V, TK, Tat, T36, T3D, TH, T2X, T30;
				   E Tau;
				   {
					E TB, TC, T2T, T2U;
					{
					     E Ty, Tz, T3y, T3z;
					     Ty = Cr[WS(csr, 2)];
					     TcA = TaU - TaX;
					     TaY = TaU + TaX;
					     T9g = FMA(KP707106781, T7R, T7Q);
					     T7S = FNMS(KP707106781, T7R, T7Q);
					     Tz = Cr[WS(csr, 62)];
					     T3y = Ci[WS(csi, 2)];
					     T3z = Ci[WS(csi, 62)];
					     TB = Cr[WS(csr, 34)];
					     T2S = Ty - Tz;
					     TA = Ty + Tz;
					     TaK = T3y - T3z;
					     T3A = T3y + T3z;
					     TC = Cr[WS(csr, 30)];
					}
					T2T = Ci[WS(csi, 34)];
					T2U = Ci[WS(csi, 30)];
					{
					     E TI, TJ, T33, T34;
					     TI = Cr[WS(csr, 14)];
					     T3x = TB - TC;
					     TD = TB + TC;
					     TaL = T2T - T2U;
					     T2V = T2T + T2U;
					     TJ = Cr[WS(csr, 50)];
					     T33 = Ci[WS(csi, 14)];
					     T34 = Ci[WS(csi, 50)];
					     {
						  E TF, T32, T35, TG, T2Y, T2Z;
						  TF = Cr[WS(csr, 18)];
						  TK = TI + TJ;
						  T32 = TI - TJ;
						  Tat = T34 - T33;
						  T35 = T33 + T34;
						  TG = Cr[WS(csr, 46)];
						  T2Y = Ci[WS(csi, 18)];
						  T2Z = Ci[WS(csi, 46)];
						  T36 = T32 - T35;
						  T3D = T32 + T35;
						  TH = TF + TG;
						  T2X = TF - TG;
						  T30 = T2Y + T2Z;
						  Tau = T2Y - T2Z;
					     }
					}
				   }
				   {
					E T3C, TdG, TdH, T2W, T37, T7I, T7H, T3B, T3E;
					{
					     E TE, T31, TL, TaJ, TaM;
					     Tas = TA - TD;
					     TE = TA + TD;
					     T3C = T2X + T30;
					     T31 = T2X - T30;
					     TL = TH + TK;
					     TaJ = TH - TK;
					     TaM = TaK - TaL;
					     TdG = TaL + TaK;
					     TdA = TE - TL;
					     TM = TE + TL;
					     Tcv = TaM - TaJ;
					     TaN = TaJ + TaM;
					     TdH = Tau + Tat;
					     Tav = Tat - Tau;
					     T7w = T2S + T2V;
					     T2W = T2S - T2V;
					     T37 = T31 + T36;
					     T7I = T36 - T31;
					}
					T7H = T3A - T3x;
					T3B = T3x + T3A;
					TeP = TdH + TdG;
					TdI = TdG - TdH;
					T6i = FNMS(KP707106781, T37, T2W);
					T38 = FMA(KP707106781, T37, T2W);
					T3E = T3C - T3D;
					T7x = T3C + T3D;
					T6l = FNMS(KP707106781, T3E, T3B);
					T3F = FMA(KP707106781, T3E, T3B);
					T9b = FMA(KP707106781, T7I, T7H);
					T7J = FNMS(KP707106781, T7I, T7H);
				   }
			      }
			      {
				   E T4r, T4I, T1F, Tbb, T4u, T4L, Tbj, TdS, T1I, Tbd, T4N, T4A, T4B, T1L, Tbc;
				   E T4E, T1M, Tbg;
				   {
					E T1z, T1A, T1C, T1D, Tbi, Tbh;
					T1z = Cr[WS(csr, 5)];
					Tcs = Tas - Tav;
					Taw = Tas + Tav;
					T98 = FMA(KP707106781, T7x, T7w);
					T7y = FNMS(KP707106781, T7x, T7w);
					T1A = Cr[WS(csr, 59)];
					T1C = Cr[WS(csr, 37)];
					T1D = Cr[WS(csr, 27)];
					{
					     E T4s, T1B, T1E, T4t, T4J, T4K;
					     T4s = Ci[WS(csi, 37)];
					     T4r = T1z - T1A;
					     T1B = T1z + T1A;
					     T4I = T1C - T1D;
					     T1E = T1C + T1D;
					     T4t = Ci[WS(csi, 27)];
					     T4J = Ci[WS(csi, 5)];
					     T4K = Ci[WS(csi, 59)];
					     T1F = T1B + T1E;
					     Tbb = T1B - T1E;
					     T4u = T4s + T4t;
					     Tbi = T4s - T4t;
					     Tbh = T4J - T4K;
					     T4L = T4J + T4K;
					}
					{
					     E T1J, T4w, T4z, T1K, T4C, T4D;
					     {
						  E T1G, T1H, T4x, T4y;
						  T1G = Cr[WS(csr, 21)];
						  Tbj = Tbh - Tbi;
						  TdS = Tbi + Tbh;
						  T1H = Cr[WS(csr, 43)];
						  T4x = Ci[WS(csi, 21)];
						  T4y = Ci[WS(csi, 43)];
						  T1J = Cr[WS(csr, 11)];
						  T4w = T1G - T1H;
						  T1I = T1G + T1H;
						  Tbd = T4x - T4y;
						  T4z = T4x + T4y;
						  T1K = Cr[WS(csr, 53)];
						  T4C = Ci[WS(csi, 11)];
						  T4D = Ci[WS(csi, 53)];
					     }
					     T4N = T4w + T4z;
					     T4A = T4w - T4z;
					     T4B = T1J - T1K;
					     T1L = T1J + T1K;
					     Tbc = T4D - T4C;
					     T4E = T4C + T4D;
					}
				   }
				   T1M = T1I + T1L;
				   Tbg = T1I - T1L;
				   {
					E TdT, Tbe, T4F, T4O;
					TdT = Tbd + Tbc;
					Tbe = Tbc - Tbd;
					T4F = T4B - T4E;
					T4O = T4B + T4E;
					{
					     E TdR, TdU, T81, T4v, T4G, T85;
					     TdR = T1F - T1M;
					     T1N = T1F + T1M;
					     TeW = TdT + TdS;
					     TdU = TdS - TdT;
					     T81 = T4r + T4u;
					     T4v = T4r - T4u;
					     T4G = T4A + T4F;
					     T85 = T4F - T4A;
					     {
						  E T84, T4M, T4P, T82, TcG, TcH;
						  T84 = T4L - T4I;
						  T4M = T4I + T4L;
						  T6x = FNMS(KP707106781, T4G, T4v);
						  T4H = FMA(KP707106781, T4G, T4v);
						  Te8 = TdR + TdU;
						  TdV = TdR - TdU;
						  T4P = T4N - T4O;
						  T82 = T4N + T4O;
						  Tbk = Tbg + Tbj;
						  TcG = Tbj - Tbg;
						  T6w = FNMS(KP707106781, T4P, T4M);
						  T4Q = FMA(KP707106781, T4P, T4M);
						  T9j = FMA(KP707106781, T85, T84);
						  T86 = FNMS(KP707106781, T85, T84);
						  TcH = Tbb - Tbe;
						  Tbf = Tbb + Tbe;
						  TcO = FMA(KP414213562, TcG, TcH);
						  TcI = FNMS(KP414213562, TcH, TcG);
						  T9k = FMA(KP707106781, T82, T81);
						  T83 = FNMS(KP707106781, T82, T81);
					     }
					}
				   }
			      }
			 }
			 {
			      E T88, T89, Tbv, Tbq;
			      {
				   E T4S, T59, T4V, Tbm, T1U, T5c, TdX, Tbu, T1X, T53, Tbo, T52, T20, T54, T5e;
				   E T51;
				   {
					E T1R, T1Q, T1S, T1O, T1P;
					T1O = Cr[WS(csr, 3)];
					T1P = Cr[WS(csr, 61)];
					T1R = Cr[WS(csr, 29)];
					TbI = FMA(KP414213562, Tbf, Tbk);
					Tbl = FNMS(KP414213562, Tbk, Tbf);
					T1Q = T1O + T1P;
					T4S = T1O - T1P;
					T1S = Cr[WS(csr, 35)];
					{
					     E Tbt, Tbs, T4X, T50;
					     {
						  E T5a, T5b, T4T, T4U, T1T;
						  T4T = Ci[WS(csi, 29)];
						  T4U = Ci[WS(csi, 35)];
						  T1T = T1R + T1S;
						  T59 = T1R - T1S;
						  T5a = Ci[WS(csi, 3)];
						  Tbt = T4T - T4U;
						  T4V = T4T + T4U;
						  T5b = Ci[WS(csi, 61)];
						  Tbm = T1Q - T1T;
						  T1U = T1Q + T1T;
						  T5c = T5a + T5b;
						  Tbs = T5b - T5a;
					     }
					     {
						  E T4Y, T4Z, T1V, T1W, T1Y, T1Z;
						  T1V = Cr[WS(csr, 13)];
						  T1W = Cr[WS(csr, 51)];
						  TdX = Tbt + Tbs;
						  Tbu = Tbs - Tbt;
						  T4Y = Ci[WS(csi, 13)];
						  T4X = T1V - T1W;
						  T1X = T1V + T1W;
						  T4Z = Ci[WS(csi, 51)];
						  T1Y = Cr[WS(csr, 19)];
						  T1Z = Cr[WS(csr, 45)];
						  T53 = Ci[WS(csi, 19)];
						  Tbo = T4Y - T4Z;
						  T50 = T4Y + T4Z;
						  T52 = T1Y - T1Z;
						  T20 = T1Y + T1Z;
						  T54 = Ci[WS(csi, 45)];
					     }
					     T5e = T4X + T50;
					     T51 = T4X - T50;
					}
				   }
				   {
					E T21, Tbr, T55, Tbn;
					T21 = T1X + T20;
					Tbr = T1X - T20;
					T55 = T53 + T54;
					Tbn = T54 - T53;
					{
					     E T4W, TdW, Tbp, T5f, TdZ, T57, T8c, TdY, T56;
					     T88 = T4S + T4V;
					     T4W = T4S - T4V;
					     T22 = T1U + T21;
					     TdW = T1U - T21;
					     TdY = Tbo + Tbn;
					     Tbp = Tbn - Tbo;
					     T56 = T52 - T55;
					     T5f = T52 + T55;
					     TeV = TdY + TdX;
					     TdZ = TdX - TdY;
					     T57 = T51 + T56;
					     T8c = T56 - T51;
					     {
						  E T8b, T5d, T5g, TcD, TcE;
						  T8b = T59 + T5c;
						  T5d = T59 - T5c;
						  T5g = T5e - T5f;
						  T89 = T5e + T5f;
						  Te0 = TdW + TdZ;
						  Te9 = TdZ - TdW;
						  T58 = FMA(KP707106781, T57, T4W);
						  T6u = FNMS(KP707106781, T57, T4W);
						  T6t = FNMS(KP707106781, T5g, T5d);
						  T5h = FMA(KP707106781, T5g, T5d);
						  Tbv = Tbr + Tbu;
						  TcD = Tbu - Tbr;
						  TcE = Tbm - Tbp;
						  Tbq = Tbm + Tbp;
						  T9m = FNMS(KP707106781, T8c, T8b);
						  T8d = FMA(KP707106781, T8c, T8b);
						  TcP = FNMS(KP414213562, TcD, TcE);
						  TcF = FMA(KP414213562, TcE, TcD);
					     }
					}
				   }
			      }
			      {
				   E Tb3, Tb8, T7V, T7Y;
				   {
					E T7T, T4c, TaZ, T1p, TdO, Tb2, T7U, T47, T1t, T4e, T1s, Tb5, T4m, T1u, T4f;
					E T4g;
					{
					     E T1m, T43, T1l, Tb0, T4b, T1n, T44, T45;
					     {
						  E T1j, T1k, T49, T4a;
						  T1j = Cr[WS(csr, 9)];
						  T9n = FMA(KP707106781, T89, T88);
						  T8a = FNMS(KP707106781, T89, T88);
						  TbJ = FNMS(KP414213562, Tbq, Tbv);
						  Tbw = FMA(KP414213562, Tbv, Tbq);
						  T1k = Cr[WS(csr, 55)];
						  T49 = Ci[WS(csi, 9)];
						  T4a = Ci[WS(csi, 55)];
						  T1m = Cr[WS(csr, 41)];
						  T43 = T1j - T1k;
						  T1l = T1j + T1k;
						  Tb0 = T49 - T4a;
						  T4b = T49 + T4a;
						  T1n = Cr[WS(csr, 23)];
						  T44 = Ci[WS(csi, 41)];
						  T45 = Ci[WS(csi, 23)];
					     }
					     {
						  E T1q, T1r, T4k, T4l;
						  T1q = Cr[WS(csr, 7)];
						  {
						       E T48, T1o, Tb1, T46;
						       T48 = T1m - T1n;
						       T1o = T1m + T1n;
						       Tb1 = T44 - T45;
						       T46 = T44 + T45;
						       T7T = T4b - T48;
						       T4c = T48 + T4b;
						       TaZ = T1l - T1o;
						       T1p = T1l + T1o;
						       TdO = Tb1 + Tb0;
						       Tb2 = Tb0 - Tb1;
						       T7U = T43 + T46;
						       T47 = T43 - T46;
						       T1r = Cr[WS(csr, 57)];
						  }
						  T4k = Ci[WS(csi, 7)];
						  T4l = Ci[WS(csi, 57)];
						  T1t = Cr[WS(csr, 25)];
						  T4e = T1q - T1r;
						  T1s = T1q + T1r;
						  Tb5 = T4l - T4k;
						  T4m = T4k + T4l;
						  T1u = Cr[WS(csr, 39)];
						  T4f = Ci[WS(csi, 25)];
						  T4g = Ci[WS(csi, 39)];
					     }
					}
					{
					     E T7W, TdN, T7X, T5u, T4d, T4o, T5v, T8k, T8l;
					     {
						  E T4n, T1w, T4i, TbE, TbF, Tb4, Tb7;
						  {
						       E T4j, T1v, Tb6, T4h;
						       T4j = T1t - T1u;
						       T1v = T1t + T1u;
						       Tb6 = T4f - T4g;
						       T4h = T4f + T4g;
						       T7W = T4j + T4m;
						       T4n = T4j - T4m;
						       Tb4 = T1s - T1v;
						       T1w = T1s + T1v;
						       TdN = Tb6 + Tb5;
						       Tb7 = Tb5 - Tb6;
						       T7X = T4e + T4h;
						       T4i = T4e - T4h;
						  }
						  Tb3 = TaZ - Tb2;
						  TbE = TaZ + Tb2;
						  TbF = Tb7 - Tb4;
						  Tb8 = Tb4 + Tb7;
						  Te3 = T1p - T1w;
						  T1x = T1p + T1w;
						  TcB = TbE - TbF;
						  TbG = TbE + TbF;
						  T5u = FMA(KP414213562, T47, T4c);
						  T4d = FNMS(KP414213562, T4c, T47);
						  T4o = FMA(KP414213562, T4n, T4i);
						  T5v = FNMS(KP414213562, T4i, T4n);
					     }
					     Tf1 = TdO + TdN;
					     TdP = TdN - TdO;
					     T6C = T4o - T4d;
					     T4p = T4d + T4o;
					     T7V = FNMS(KP414213562, T7U, T7T);
					     T8k = FMA(KP414213562, T7T, T7U);
					     T8l = FMA(KP414213562, T7W, T7X);
					     T7Y = FNMS(KP414213562, T7X, T7W);
					     T6r = T5u - T5v;
					     T5w = T5u + T5v;
					     T9h = T8k + T8l;
					     T8m = T8k - T8l;
					}
				   }
				   {
					E T7z, T3i, Tax, TT, TdC, TaA, T7A, T3d, TX, T3k, TW, TaD, T3s, TY, T3l;
					E T3m;
					{
					     E TQ, T39, TP, Tay, T3h, TR, T3a, T3b;
					     {
						  E TN, TO, T3f, T3g;
						  TN = Cr[WS(csr, 10)];
						  TcM = Tb8 - Tb3;
						  Tb9 = Tb3 + Tb8;
						  T9s = T7V - T7Y;
						  T7Z = T7V + T7Y;
						  TO = Cr[WS(csr, 54)];
						  T3f = Ci[WS(csi, 10)];
						  T3g = Ci[WS(csi, 54)];
						  TQ = Cr[WS(csr, 42)];
						  T39 = TN - TO;
						  TP = TN + TO;
						  Tay = T3f - T3g;
						  T3h = T3f + T3g;
						  TR = Cr[WS(csr, 22)];
						  T3a = Ci[WS(csi, 42)];
						  T3b = Ci[WS(csi, 22)];
					     }
					     {
						  E TU, TV, T3q, T3r;
						  TU = Cr[WS(csr, 6)];
						  {
						       E T3e, TS, Taz, T3c;
						       T3e = TQ - TR;
						       TS = TQ + TR;
						       Taz = T3a - T3b;
						       T3c = T3a + T3b;
						       T7z = T3h - T3e;
						       T3i = T3e + T3h;
						       Tax = TP - TS;
						       TT = TP + TS;
						       TdC = Taz + Tay;
						       TaA = Tay - Taz;
						       T7A = T39 + T3c;
						       T3d = T39 - T3c;
						       TV = Cr[WS(csr, 58)];
						  }
						  T3q = Ci[WS(csi, 6)];
						  T3r = Ci[WS(csi, 58)];
						  TX = Cr[WS(csr, 26)];
						  T3k = TU - TV;
						  TW = TU + TV;
						  TaD = T3r - T3q;
						  T3s = T3q + T3r;
						  TY = Cr[WS(csr, 38)];
						  T3l = Ci[WS(csi, 26)];
						  T3m = Ci[WS(csi, 38)];
					     }
					}
					{
					     E T7C, TdB, T7D, T3G, T3j, T3u, T3H, T7K, T7L;
					     {
						  E T3t, T10, T3o, TaO, TaP, TaC, TaF;
						  {
						       E T3p, TZ, TaE, T3n;
						       T3p = TX - TY;
						       TZ = TX + TY;
						       TaE = T3l - T3m;
						       T3n = T3l + T3m;
						       T7C = T3p + T3s;
						       T3t = T3p - T3s;
						       TaC = TW - TZ;
						       T10 = TW + TZ;
						       TdB = TaE + TaD;
						       TaF = TaD - TaE;
						       T7D = T3k + T3n;
						       T3o = T3k - T3n;
						  }
						  TaB = Tax - TaA;
						  TaO = Tax + TaA;
						  TaP = TaF - TaC;
						  TaG = TaC + TaF;
						  TdF = TT - T10;
						  T11 = TT + T10;
						  Tct = TaO - TaP;
						  TaQ = TaO + TaP;
						  T3G = FMA(KP414213562, T3d, T3i);
						  T3j = FNMS(KP414213562, T3i, T3d);
						  T3u = FMA(KP414213562, T3t, T3o);
						  T3H = FNMS(KP414213562, T3o, T3t);
					     }
					     TeQ = TdC + TdB;
					     TdD = TdB - TdC;
					     T6m = T3u - T3j;
					     T3v = T3j + T3u;
					     T7B = FNMS(KP414213562, T7A, T7z);
					     T7K = FMA(KP414213562, T7z, T7A);
					     T7L = FMA(KP414213562, T7C, T7D);
					     T7E = FNMS(KP414213562, T7D, T7C);
					     T6j = T3G - T3H;
					     T3I = T3G + T3H;
					     T99 = T7K + T7L;
					     T7M = T7K - T7L;
					}
				   }
			      }
			 }
		    }
		    {
			 E Tcw, T9c, T7F, Tev, Teu, TeD, Tep, TeG, Tez, TeE, Tes;
			 {
			      E TbX, TbY, Tc7, TbP, Tar, Tc5, Tc1, Tc0, Tc4, Tba, TbS, TbL, TbQ, TaS, Tbx;
			      E Tc8;
			      {
				   E TeO, TaH, TeR, TeL, TeU, TeZ, Tf2, TeX, Tfh, Tfn, Tfo, Tfm;
				   {
					E T12, Tfg, Tfj, Tx, Tff, T24, Tfi, Tfk, Th, T1y, T23;
					TeO = TM - T11;
					T12 = TM + T11;
					Tcw = TaG - TaB;
					TaH = TaB + TaG;
					T9c = T7B - T7E;
					T7F = T7B + T7E;
					Tfg = TeQ + TeP;
					TeR = TeP - TeQ;
					TeL = FNMS(KP2_000000000, Tg, T9);
					Th = FMA(KP2_000000000, Tg, T9);
					T1y = T1i + T1x;
					TeU = T1i - T1x;
					TeZ = T1N - T22;
					T23 = T1N + T22;
					Tfj = Tf1 + Tf0;
					Tf2 = Tf0 - Tf1;
					Tx = FMA(KP2_000000000, Tw, Th);
					Tff = FNMS(KP2_000000000, Tw, Th);
					T24 = T1y + T23;
					Tfi = T1y - T23;
					TeX = TeV - TeW;
					Tfk = TeW + TeV;
					{
					     E T13, Tfp, Tfl, Tfq;
					     T13 = FMA(KP2_000000000, T12, Tx);
					     Tfp = FNMS(KP2_000000000, T12, Tx);
					     Tfh = FNMS(KP2_000000000, Tfg, Tff);
					     Tfn = FMA(KP2_000000000, Tfg, Tff);
					     Tfl = Tfj - Tfk;
					     Tfq = Tfk + Tfj;
					     R0[0] = FMA(KP2_000000000, T24, T13);
					     R0[WS(rs, 32)] = FNMS(KP2_000000000, T24, T13);
					     R0[WS(rs, 48)] = FMA(KP2_000000000, Tfq, Tfp);
					     R0[WS(rs, 16)] = FNMS(KP2_000000000, Tfq, Tfp);
					     Tfo = Tfi + Tfl;
					     Tfm = Tfi - Tfl;
					}
				   }
				   {
					E Tf7, TeN, Tfa, Tf3, Tf8, TeS;
					R0[WS(rs, 8)] = FMA(KP1_414213562, Tfm, Tfh);
					R0[WS(rs, 40)] = FNMS(KP1_414213562, Tfm, Tfh);
					R0[WS(rs, 56)] = FMA(KP1_414213562, Tfo, Tfn);
					R0[WS(rs, 24)] = FNMS(KP1_414213562, Tfo, Tfn);
					Tf7 = FMA(KP2_000000000, TeM, TeL);
					TeN = FNMS(KP2_000000000, TeM, TeL);
					Tfa = Tf2 - TeZ;
					Tf3 = TeZ + Tf2;
					Tf8 = TeO + TeR;
					TeS = TeO - TeR;
					{
					     E TbH, TbK, TaI, TaR;
					     {
						  E Taf, Tf9, Tfd, Tf5, TeT, Tfb, TeY, Taq;
						  TbX = FNMS(KP1_414213562, Tae, Ta9);
						  Taf = FMA(KP1_414213562, Tae, Ta9);
						  Tf9 = FNMS(KP1_414213562, Tf8, Tf7);
						  Tfd = FMA(KP1_414213562, Tf8, Tf7);
						  Tf5 = FNMS(KP1_414213562, TeS, TeN);
						  TeT = FMA(KP1_414213562, TeS, TeN);
						  Tfb = TeU - TeX;
						  TeY = TeU + TeX;
						  Taq = FNMS(KP414213562, Tap, Tak);
						  TbY = FMA(KP414213562, Tak, Tap);
						  Tc7 = FNMS(KP707106781, TbG, TbD);
						  TbH = FMA(KP707106781, TbG, TbD);
						  {
						       E Tfc, Tfe, Tf6, Tf4;
						       Tfc = FNMS(KP414213562, Tfb, Tfa);
						       Tfe = FMA(KP414213562, Tfa, Tfb);
						       Tf6 = FMA(KP414213562, TeY, Tf3);
						       Tf4 = FNMS(KP414213562, Tf3, TeY);
						       TbP = FNMS(KP1_847759065, Taq, Taf);
						       Tar = FMA(KP1_847759065, Taq, Taf);
						       R0[WS(rs, 44)] = FMA(KP1_847759065, Tfc, Tf9);
						       R0[WS(rs, 12)] = FNMS(KP1_847759065, Tfc, Tf9);
						       R0[WS(rs, 60)] = FMA(KP1_847759065, Tfe, Tfd);
						       R0[WS(rs, 28)] = FNMS(KP1_847759065, Tfe, Tfd);
						       R0[WS(rs, 52)] = FMA(KP1_847759065, Tf6, Tf5);
						       R0[WS(rs, 20)] = FNMS(KP1_847759065, Tf6, Tf5);
						       R0[WS(rs, 4)] = FMA(KP1_847759065, Tf4, TeT);
						       R0[WS(rs, 36)] = FNMS(KP1_847759065, Tf4, TeT);
						       TbK = TbI + TbJ;
						       Tc5 = TbI - TbJ;
						  }
					     }
					     Tc1 = FNMS(KP707106781, TaH, Taw);
					     TaI = FMA(KP707106781, TaH, Taw);
					     TaR = FMA(KP707106781, TaQ, TaN);
					     Tc0 = FNMS(KP707106781, TaQ, TaN);
					     Tc4 = FNMS(KP707106781, Tb9, TaY);
					     Tba = FMA(KP707106781, Tb9, TaY);
					     TbS = FNMS(KP923879532, TbK, TbH);
					     TbL = FMA(KP923879532, TbK, TbH);
					     TbQ = FMA(KP198912367, TaI, TaR);
					     TaS = FNMS(KP198912367, TaR, TaI);
					     Tbx = Tbl + Tbw;
					     Tc8 = Tbw - Tbl;
					}
				   }
			      }
			      {
				   E Ten, Teo, Tex, Tef, Tdz, Ter, Teq, TdQ, Tei, Teb, Teg, TdK, Te1, Tey;
				   {
					E Te7, Tea, TdE, TdJ;
					{
					     E Tdt, TbR, TbV, TbN, TaT, TbT, Tby, Tdy;
					     Ten = FMA(KP2_000000000, Tds, Tdr);
					     Tdt = FNMS(KP2_000000000, Tds, Tdr);
					     TbR = FNMS(KP1_961570560, TbQ, TbP);
					     TbV = FMA(KP1_961570560, TbQ, TbP);
					     TbN = FNMS(KP1_961570560, TaS, Tar);
					     TaT = FMA(KP1_961570560, TaS, Tar);
					     TbT = FNMS(KP923879532, Tbx, Tba);
					     Tby = FMA(KP923879532, Tbx, Tba);
					     Tdy = Tdu - Tdx;
					     Teo = Tdu + Tdx;
					     Tex = Te6 - Te3;
					     Te7 = Te3 + Te6;
					     {
						  E TbU, TbW, TbO, TbM;
						  TbU = FNMS(KP820678790, TbT, TbS);
						  TbW = FMA(KP820678790, TbS, TbT);
						  TbO = FMA(KP098491403, Tby, TbL);
						  TbM = FNMS(KP098491403, TbL, Tby);
						  Tef = FNMS(KP1_414213562, Tdy, Tdt);
						  Tdz = FMA(KP1_414213562, Tdy, Tdt);
						  R0[WS(rs, 41)] = FMA(KP1_546020906, TbU, TbR);
						  R0[WS(rs, 9)] = FNMS(KP1_546020906, TbU, TbR);
						  R0[WS(rs, 57)] = FMA(KP1_546020906, TbW, TbV);
						  R0[WS(rs, 25)] = FNMS(KP1_546020906, TbW, TbV);
						  R0[WS(rs, 49)] = FMA(KP1_990369453, TbO, TbN);
						  R0[WS(rs, 17)] = FNMS(KP1_990369453, TbO, TbN);
						  R0[WS(rs, 1)] = FMA(KP1_990369453, TbM, TaT);
						  R0[WS(rs, 33)] = FNMS(KP1_990369453, TbM, TaT);
						  Tea = Te8 + Te9;
						  Tev = Te8 - Te9;
					     }
					}
					Ter = TdA - TdD;
					TdE = TdA + TdD;
					TdJ = TdF + TdI;
					Teq = TdI - TdF;
					Teu = TdM - TdP;
					TdQ = TdM + TdP;
					Tei = FNMS(KP707106781, Tea, Te7);
					Teb = FMA(KP707106781, Tea, Te7);
					Teg = FMA(KP414213562, TdE, TdJ);
					TdK = FNMS(KP414213562, TdJ, TdE);
					Te1 = TdV + Te0;
					Tey = Te0 - TdV;
				   }
				   {
					E Tcd, TbZ, Tcg, Tc9, Tce, Tc2;
					{
					     E Teh, Tel, Ted, TdL, Tej, Te2;
					     Teh = FNMS(KP1_847759065, Teg, Tef);
					     Tel = FMA(KP1_847759065, Teg, Tef);
					     Ted = FNMS(KP1_847759065, TdK, Tdz);
					     TdL = FMA(KP1_847759065, TdK, Tdz);
					     Tej = FNMS(KP707106781, Te1, TdQ);
					     Te2 = FMA(KP707106781, Te1, TdQ);
					     {
						  E Tek, Tem, Tee, Tec;
						  Tek = FNMS(KP668178637, Tej, Tei);
						  Tem = FMA(KP668178637, Tei, Tej);
						  Tee = FMA(KP198912367, Te2, Teb);
						  Tec = FNMS(KP198912367, Teb, Te2);
						  Tcd = FMA(KP1_847759065, TbY, TbX);
						  TbZ = FNMS(KP1_847759065, TbY, TbX);
						  R0[WS(rs, 42)] = FMA(KP1_662939224, Tek, Teh);
						  R0[WS(rs, 10)] = FNMS(KP1_662939224, Tek, Teh);
						  R0[WS(rs, 58)] = FMA(KP1_662939224, Tem, Tel);
						  R0[WS(rs, 26)] = FNMS(KP1_662939224, Tem, Tel);
						  R0[WS(rs, 50)] = FMA(KP1_961570560, Tee, Ted);
						  R0[WS(rs, 18)] = FNMS(KP1_961570560, Tee, Ted);
						  R0[WS(rs, 2)] = FMA(KP1_961570560, Tec, TdL);
						  R0[WS(rs, 34)] = FNMS(KP1_961570560, Tec, TdL);
					     }
					}
					Tcg = FMA(KP923879532, Tc8, Tc7);
					Tc9 = FNMS(KP923879532, Tc8, Tc7);
					Tce = FMA(KP668178637, Tc0, Tc1);
					Tc2 = FNMS(KP668178637, Tc1, Tc0);
					{
					     E Tcf, Tcj, Tcb, Tc3, Tch, Tc6;
					     Tcf = FNMS(KP1_662939224, Tce, Tcd);
					     Tcj = FMA(KP1_662939224, Tce, Tcd);
					     Tcb = FMA(KP1_662939224, Tc2, TbZ);
					     Tc3 = FNMS(KP1_662939224, Tc2, TbZ);
					     Tch = FMA(KP923879532, Tc5, Tc4);
					     Tc6 = FNMS(KP923879532, Tc5, Tc4);
					     {
						  E Tci, Tck, Tcc, Tca;
						  Tci = FNMS(KP303346683, Tch, Tcg);
						  Tck = FMA(KP303346683, Tcg, Tch);
						  Tcc = FMA(KP534511135, Tc6, Tc9);
						  Tca = FNMS(KP534511135, Tc9, Tc6);
						  TeD = FMA(KP1_414213562, Teo, Ten);
						  Tep = FNMS(KP1_414213562, Teo, Ten);
						  R0[WS(rs, 45)] = FMA(KP1_913880671, Tci, Tcf);
						  R0[WS(rs, 13)] = FNMS(KP1_913880671, Tci, Tcf);
						  R0[WS(rs, 61)] = FMA(KP1_913880671, Tck, Tcj);
						  R0[WS(rs, 29)] = FNMS(KP1_913880671, Tck, Tcj);
						  R0[WS(rs, 53)] = FMA(KP1_763842528, Tcc, Tcb);
						  R0[WS(rs, 21)] = FNMS(KP1_763842528, Tcc, Tcb);
						  R0[WS(rs, 5)] = FMA(KP1_763842528, Tca, Tc3);
						  R0[WS(rs, 37)] = FNMS(KP1_763842528, Tca, Tc3);
					     }
					}
					TeG = FMA(KP707106781, Tey, Tex);
					Tez = FNMS(KP707106781, Tey, Tex);
					TeE = FMA(KP414213562, Teq, Ter);
					Tes = FNMS(KP414213562, Ter, Teq);
				   }
			      }
			 }
			 {
			      E T5L, T5M, T61, T62;
			      {
				   E Td3, Td4, Tdd, TcV, Tcr, Tdb, Td7, Td6, Tda, TcC, TcY, TcR, TcW, Tcy, TcJ;
				   E Tde;
				   {
					E TcN, TcQ, Tcu, Tcx;
					{
					     E Tcn, TeF, TeJ, TeB, Tet, TeH, Tew, Tcq;
					     Td3 = FMA(KP1_414213562, Tcm, Tcl);
					     Tcn = FNMS(KP1_414213562, Tcm, Tcl);
					     TeF = FNMS(KP1_847759065, TeE, TeD);
					     TeJ = FMA(KP1_847759065, TeE, TeD);
					     TeB = FMA(KP1_847759065, Tes, Tep);
					     Tet = FNMS(KP1_847759065, Tes, Tep);
					     TeH = FMA(KP707106781, Tev, Teu);
					     Tew = FNMS(KP707106781, Tev, Teu);
					     Tcq = FNMS(KP414213562, Tcp, Tco);
					     Td4 = FMA(KP414213562, Tco, Tcp);
					     Tdd = FMA(KP707106781, TcM, TcL);
					     TcN = FNMS(KP707106781, TcM, TcL);
					     {
						  E TeI, TeK, TeC, TeA;
						  TeI = FNMS(KP198912367, TeH, TeG);
						  TeK = FMA(KP198912367, TeG, TeH);
						  TeC = FMA(KP668178637, Tew, Tez);
						  TeA = FNMS(KP668178637, Tez, Tew);
						  TcV = FMA(KP1_847759065, Tcq, Tcn);
						  Tcr = FNMS(KP1_847759065, Tcq, Tcn);
						  R0[WS(rs, 46)] = FMA(KP1_961570560, TeI, TeF);
						  R0[WS(rs, 14)] = FNMS(KP1_961570560, TeI, TeF);
						  R0[WS(rs, 62)] = FMA(KP1_961570560, TeK, TeJ);
						  R0[WS(rs, 30)] = FNMS(KP1_961570560, TeK, TeJ);
						  R0[WS(rs, 54)] = FMA(KP1_662939224, TeC, TeB);
						  R0[WS(rs, 22)] = FNMS(KP1_662939224, TeC, TeB);
						  R0[WS(rs, 6)] = FMA(KP1_662939224, TeA, Tet);
						  R0[WS(rs, 38)] = FNMS(KP1_662939224, TeA, Tet);
						  TcQ = TcO - TcP;
						  Tdb = TcO + TcP;
					     }
					}
					Td7 = FMA(KP707106781, Tct, Tcs);
					Tcu = FNMS(KP707106781, Tct, Tcs);
					Tcx = FNMS(KP707106781, Tcw, Tcv);
					Td6 = FMA(KP707106781, Tcw, Tcv);
					Tda = FMA(KP707106781, TcB, TcA);
					TcC = FNMS(KP707106781, TcB, TcA);
					TcY = FNMS(KP923879532, TcQ, TcN);
					TcR = FMA(KP923879532, TcQ, TcN);
					TcW = FMA(KP668178637, Tcu, Tcx);
					Tcy = FNMS(KP668178637, Tcx, Tcu);
					TcJ = TcF - TcI;
					Tde = TcI + TcF;
				   }
				   {
					E Tdj, Td5, Tdm, Tdf, Tdk, Td8;
					{
					     E TcX, Td1, TcT, Tcz, TcZ, TcK;
					     TcX = FNMS(KP1_662939224, TcW, TcV);
					     Td1 = FMA(KP1_662939224, TcW, TcV);
					     TcT = FNMS(KP1_662939224, Tcy, Tcr);
					     Tcz = FMA(KP1_662939224, Tcy, Tcr);
					     TcZ = FNMS(KP923879532, TcJ, TcC);
					     TcK = FMA(KP923879532, TcJ, TcC);
					     {
						  E Td0, Td2, TcU, TcS;
						  Td0 = FNMS(KP534511135, TcZ, TcY);
						  Td2 = FMA(KP534511135, TcY, TcZ);
						  TcU = FMA(KP303346683, TcK, TcR);
						  TcS = FNMS(KP303346683, TcR, TcK);
						  Tdj = FMA(KP1_847759065, Td4, Td3);
						  Td5 = FNMS(KP1_847759065, Td4, Td3);
						  R0[WS(rs, 43)] = FMA(KP1_763842528, Td0, TcX);
						  R0[WS(rs, 11)] = FNMS(KP1_763842528, Td0, TcX);
						  R0[WS(rs, 59)] = FMA(KP1_763842528, Td2, Td1);
						  R0[WS(rs, 27)] = FNMS(KP1_763842528, Td2, Td1);
						  R0[WS(rs, 51)] = FMA(KP1_913880671, TcU, TcT);
						  R0[WS(rs, 19)] = FNMS(KP1_913880671, TcU, TcT);
						  R0[WS(rs, 3)] = FMA(KP1_913880671, TcS, Tcz);
						  R0[WS(rs, 35)] = FNMS(KP1_913880671, TcS, Tcz);
					     }
					}
					Tdm = FMA(KP923879532, Tde, Tdd);
					Tdf = FNMS(KP923879532, Tde, Tdd);
					Tdk = FMA(KP198912367, Td6, Td7);
					Td8 = FNMS(KP198912367, Td7, Td6);
					{
					     E T5F, T2R, T5G, T3K, T64, T5S, T5X, T5x, T5U, T4q, T4R, T63, T5P, T5i, T5V;
					     E T5A;
					     {
						  E T5N, T5O, T5R, T3w, T3J, T5Q, T5y, T5z;
						  {
						       E T2p, Tdl, Tdp, Tdh, Td9, Tdn, Tdc, T2Q;
						       T5N = FNMS(KP1_847759065, T2o, T2d);
						       T2p = FMA(KP1_847759065, T2o, T2d);
						       Tdl = FNMS(KP1_961570560, Tdk, Tdj);
						       Tdp = FMA(KP1_961570560, Tdk, Tdj);
						       Tdh = FMA(KP1_961570560, Td8, Td5);
						       Td9 = FNMS(KP1_961570560, Td8, Td5);
						       Tdn = FMA(KP923879532, Tdb, Tda);
						       Tdc = FNMS(KP923879532, Tdb, Tda);
						       T2Q = FNMS(KP198912367, T2P, T2G);
						       T5O = FMA(KP198912367, T2G, T2P);
						       T5R = FNMS(KP923879532, T3v, T38);
						       T3w = FMA(KP923879532, T3v, T38);
						       {
							    E Tdo, Tdq, Tdi, Tdg;
							    Tdo = FNMS(KP098491403, Tdn, Tdm);
							    Tdq = FMA(KP098491403, Tdm, Tdn);
							    Tdi = FMA(KP820678790, Tdc, Tdf);
							    Tdg = FNMS(KP820678790, Tdf, Tdc);
							    T5F = FNMS(KP1_961570560, T2Q, T2p);
							    T2R = FMA(KP1_961570560, T2Q, T2p);
							    R0[WS(rs, 47)] = FMA(KP1_990369453, Tdo, Tdl);
							    R0[WS(rs, 15)] = FNMS(KP1_990369453, Tdo, Tdl);
							    R0[WS(rs, 63)] = FMA(KP1_990369453, Tdq, Tdp);
							    R0[WS(rs, 31)] = FNMS(KP1_990369453, Tdq, Tdp);
							    R0[WS(rs, 55)] = FMA(KP1_546020906, Tdi, Tdh);
							    R0[WS(rs, 23)] = FNMS(KP1_546020906, Tdi, Tdh);
							    R0[WS(rs, 7)] = FMA(KP1_546020906, Tdg, Td9);
							    R0[WS(rs, 39)] = FNMS(KP1_546020906, Tdg, Td9);
							    T3J = FMA(KP923879532, T3I, T3F);
							    T5Q = FNMS(KP923879532, T3I, T3F);
						       }
						  }
						  T5G = FMA(KP098491403, T3w, T3J);
						  T3K = FNMS(KP098491403, T3J, T3w);
						  T64 = FMA(KP820678790, T5Q, T5R);
						  T5S = FNMS(KP820678790, T5R, T5Q);
						  T5X = FNMS(KP923879532, T5w, T5t);
						  T5x = FMA(KP923879532, T5w, T5t);
						  T5U = FNMS(KP923879532, T4p, T42);
						  T4q = FMA(KP923879532, T4p, T42);
						  T4R = FNMS(KP198912367, T4Q, T4H);
						  T5y = FMA(KP198912367, T4H, T4Q);
						  T63 = FMA(KP1_961570560, T5O, T5N);
						  T5P = FNMS(KP1_961570560, T5O, T5N);
						  T5z = FNMS(KP198912367, T58, T5h);
						  T5i = FMA(KP198912367, T5h, T58);
						  T5V = T5y - T5z;
						  T5A = T5y + T5z;
					     }
					     {
						  E T5W, T5I, T5Z, T5J;
						  {
						       E T5D, T3L, T67, T5B, T5Y, T5j, T65, T69, T66, T5k;
						       T5D = FNMS(KP1_990369453, T3K, T2R);
						       T3L = FMA(KP1_990369453, T3K, T2R);
						       T5W = FNMS(KP980785280, T5V, T5U);
						       T67 = FMA(KP980785280, T5V, T5U);
						       T5I = FNMS(KP980785280, T5A, T5x);
						       T5B = FMA(KP980785280, T5A, T5x);
						       T5Y = T5i - T4R;
						       T5j = T4R + T5i;
						       T65 = FNMS(KP1_546020906, T64, T63);
						       T69 = FMA(KP1_546020906, T64, T63);
						       T5Z = FNMS(KP980785280, T5Y, T5X);
						       T66 = FMA(KP980785280, T5Y, T5X);
						       T5J = FNMS(KP980785280, T5j, T4q);
						       T5k = FMA(KP980785280, T5j, T4q);
						       {
							    E T68, T6a, T5E, T5C;
							    T68 = FNMS(KP357805721, T67, T66);
							    T6a = FMA(KP357805721, T66, T67);
							    T5E = FMA(KP049126849, T5k, T5B);
							    T5C = FNMS(KP049126849, T5B, T5k);
							    R1[WS(rs, 60)] = FMA(KP1_883088130, T6a, T69);
							    R1[WS(rs, 28)] = FNMS(KP1_883088130, T6a, T69);
							    R1[WS(rs, 44)] = FMA(KP1_883088130, T68, T65);
							    R1[WS(rs, 12)] = FNMS(KP1_883088130, T68, T65);
							    R1[0] = FMA(KP1_997590912, T5C, T3L);
							    R1[WS(rs, 32)] = FNMS(KP1_997590912, T5C, T3L);
							    R1[WS(rs, 16)] = FNMS(KP1_997590912, T5E, T5D);
							    R1[WS(rs, 48)] = FMA(KP1_997590912, T5E, T5D);
						       }
						  }
						  {
						       E T5H, T5K, T5T, T60;
						       T5L = FMA(KP1_990369453, T5G, T5F);
						       T5H = FNMS(KP1_990369453, T5G, T5F);
						       T5K = FNMS(KP906347169, T5J, T5I);
						       T5M = FMA(KP906347169, T5I, T5J);
						       T61 = FMA(KP1_546020906, T5S, T5P);
						       T5T = FNMS(KP1_546020906, T5S, T5P);
						       T60 = FNMS(KP472964775, T5Z, T5W);
						       T62 = FMA(KP472964775, T5W, T5Z);
						       R1[WS(rs, 40)] = FMA(KP1_481902250, T5K, T5H);
						       R1[WS(rs, 8)] = FNMS(KP1_481902250, T5K, T5H);
						       R1[WS(rs, 4)] = FMA(KP1_807978586, T60, T5T);
						       R1[WS(rs, 36)] = FNMS(KP1_807978586, T60, T5T);
						  }
					     }
					}
				   }
			      }
			      {
				   E T8B, T8C, T8R, T8S;
				   {
					E T8v, T7v, T8w, T7O, T8N, T8n, T8U, T8I, T8T, T8F, T8K, T80, T87, T8e, T8L;
					E T8q;
					{
					     E T8D, T8E, T8H, T8G, T8o, T8p;
					     {
						  E T7n, T7u, T7G, T7N;
						  T8D = FMA(KP1_847759065, T7m, T7j);
						  T7n = FNMS(KP1_847759065, T7m, T7j);
						  R1[WS(rs, 52)] = FMA(KP1_807978586, T62, T61);
						  R1[WS(rs, 20)] = FNMS(KP1_807978586, T62, T61);
						  R1[WS(rs, 56)] = FMA(KP1_481902250, T5M, T5L);
						  R1[WS(rs, 24)] = FNMS(KP1_481902250, T5M, T5L);
						  T7u = FNMS(KP668178637, T7t, T7q);
						  T8E = FMA(KP668178637, T7q, T7t);
						  T8H = FMA(KP923879532, T7F, T7y);
						  T7G = FNMS(KP923879532, T7F, T7y);
						  T7N = FMA(KP923879532, T7M, T7J);
						  T8G = FNMS(KP923879532, T7M, T7J);
						  T8v = FNMS(KP1_662939224, T7u, T7n);
						  T7v = FMA(KP1_662939224, T7u, T7n);
						  T8w = FMA(KP303346683, T7G, T7N);
						  T7O = FNMS(KP303346683, T7N, T7G);
					     }
					     T8N = FNMS(KP923879532, T8m, T8j);
					     T8n = FMA(KP923879532, T8m, T8j);
					     T8U = FMA(KP534511135, T8G, T8H);
					     T8I = FNMS(KP534511135, T8H, T8G);
					     T8T = FMA(KP1_662939224, T8E, T8D);
					     T8F = FNMS(KP1_662939224, T8E, T8D);
					     T8K = FMA(KP923879532, T7Z, T7S);
					     T80 = FNMS(KP923879532, T7Z, T7S);
					     T87 = FNMS(KP668178637, T86, T83);
					     T8o = FMA(KP668178637, T83, T86);
					     T8p = FMA(KP668178637, T8a, T8d);
					     T8e = FNMS(KP668178637, T8d, T8a);
					     T8L = T8o + T8p;
					     T8q = T8o - T8p;
					}
					{
					     E T8M, T8y, T8P, T8z;
					     {
						  E T8t, T7P, T8X, T8r, T8O, T8f, T8V, T8Z, T8W, T8g;
						  T8t = FNMS(KP1_913880671, T7O, T7v);
						  T7P = FMA(KP1_913880671, T7O, T7v);
						  T8M = FNMS(KP831469612, T8L, T8K);
						  T8X = FMA(KP831469612, T8L, T8K);
						  T8y = FNMS(KP831469612, T8q, T8n);
						  T8r = FMA(KP831469612, T8q, T8n);
						  T8O = T8e - T87;
						  T8f = T87 + T8e;
						  T8V = FNMS(KP1_763842528, T8U, T8T);
						  T8Z = FMA(KP1_763842528, T8U, T8T);
						  T8P = FNMS(KP831469612, T8O, T8N);
						  T8W = FMA(KP831469612, T8O, T8N);
						  T8z = FNMS(KP831469612, T8f, T80);
						  T8g = FMA(KP831469612, T8f, T80);
						  {
						       E T8Y, T90, T8u, T8s;
						       T8Y = FNMS(KP250486960, T8X, T8W);
						       T90 = FMA(KP250486960, T8W, T8X);
						       T8u = FMA(KP148335987, T8g, T8r);
						       T8s = FNMS(KP148335987, T8r, T8g);
						       R1[WS(rs, 61)] = FMA(KP1_940062506, T90, T8Z);
						       R1[WS(rs, 29)] = FNMS(KP1_940062506, T90, T8Z);
						       R1[WS(rs, 45)] = FMA(KP1_940062506, T8Y, T8V);
						       R1[WS(rs, 13)] = FNMS(KP1_940062506, T8Y, T8V);
						       R1[WS(rs, 1)] = FMA(KP1_978353019, T8s, T7P);
						       R1[WS(rs, 33)] = FNMS(KP1_978353019, T8s, T7P);
						       R1[WS(rs, 17)] = FNMS(KP1_978353019, T8u, T8t);
						       R1[WS(rs, 49)] = FMA(KP1_978353019, T8u, T8t);
						  }
					     }
					     {
						  E T8x, T8A, T8J, T8Q;
						  T8B = FMA(KP1_913880671, T8w, T8v);
						  T8x = FNMS(KP1_913880671, T8w, T8v);
						  T8A = FNMS(KP741650546, T8z, T8y);
						  T8C = FMA(KP741650546, T8y, T8z);
						  T8R = FMA(KP1_763842528, T8I, T8F);
						  T8J = FNMS(KP1_763842528, T8I, T8F);
						  T8Q = FNMS(KP599376933, T8P, T8M);
						  T8S = FMA(KP599376933, T8M, T8P);
						  R1[WS(rs, 41)] = FMA(KP1_606415062, T8A, T8x);
						  R1[WS(rs, 9)] = FNMS(KP1_606415062, T8A, T8x);
						  R1[WS(rs, 5)] = FMA(KP1_715457220, T8Q, T8J);
						  R1[WS(rs, 37)] = FNMS(KP1_715457220, T8Q, T8J);
					     }
					}
				   }
				   {
					E T6R, T6S, T77, T78;
					{
					     E T6L, T6h, T6M, T6o, T73, T6D, T7a, T6Y, T79, T6V, T70, T6s, T6y, T6v, T71;
					     E T6G;
					     {
						  E T6T, T6U, T6X, T6W, T6E, T6F;
						  {
						       E T6d, T6g, T6k, T6n;
						       T6T = FMA(KP1_847759065, T6c, T6b);
						       T6d = FNMS(KP1_847759065, T6c, T6b);
						       R1[WS(rs, 53)] = FMA(KP1_715457220, T8S, T8R);
						       R1[WS(rs, 21)] = FNMS(KP1_715457220, T8S, T8R);
						       R1[WS(rs, 57)] = FMA(KP1_606415062, T8C, T8B);
						       R1[WS(rs, 25)] = FNMS(KP1_606415062, T8C, T8B);
						       T6g = FNMS(KP668178637, T6f, T6e);
						       T6U = FMA(KP668178637, T6e, T6f);
						       T6X = FMA(KP923879532, T6j, T6i);
						       T6k = FNMS(KP923879532, T6j, T6i);
						       T6n = FNMS(KP923879532, T6m, T6l);
						       T6W = FMA(KP923879532, T6m, T6l);
						       T6L = FMA(KP1_662939224, T6g, T6d);
						       T6h = FNMS(KP1_662939224, T6g, T6d);
						       T6M = FMA(KP534511135, T6k, T6n);
						       T6o = FNMS(KP534511135, T6n, T6k);
						  }
						  T73 = FMA(KP923879532, T6C, T6B);
						  T6D = FNMS(KP923879532, T6C, T6B);
						  T7a = FMA(KP303346683, T6W, T6X);
						  T6Y = FNMS(KP303346683, T6X, T6W);
						  T79 = FMA(KP1_662939224, T6U, T6T);
						  T6V = FNMS(KP1_662939224, T6U, T6T);
						  T70 = FMA(KP923879532, T6r, T6q);
						  T6s = FNMS(KP923879532, T6r, T6q);
						  T6y = FNMS(KP668178637, T6x, T6w);
						  T6E = FMA(KP668178637, T6w, T6x);
						  T6F = FNMS(KP668178637, T6t, T6u);
						  T6v = FMA(KP668178637, T6u, T6t);
						  T71 = T6E + T6F;
						  T6G = T6E - T6F;
					     }
					     {
						  E T72, T6O, T75, T6P;
						  {
						       E T6J, T6p, T7d, T6H, T74, T6z, T7b, T7f, T7c, T6A;
						       T6J = FNMS(KP1_763842528, T6o, T6h);
						       T6p = FMA(KP1_763842528, T6o, T6h);
						       T72 = FNMS(KP831469612, T71, T70);
						       T7d = FMA(KP831469612, T71, T70);
						       T6O = FNMS(KP831469612, T6G, T6D);
						       T6H = FMA(KP831469612, T6G, T6D);
						       T74 = T6y + T6v;
						       T6z = T6v - T6y;
						       T7b = FNMS(KP1_913880671, T7a, T79);
						       T7f = FMA(KP1_913880671, T7a, T79);
						       T75 = FNMS(KP831469612, T74, T73);
						       T7c = FMA(KP831469612, T74, T73);
						       T6P = FNMS(KP831469612, T6z, T6s);
						       T6A = FMA(KP831469612, T6z, T6s);
						       {
							    E T7e, T7g, T6K, T6I;
							    T7e = FNMS(KP148335987, T7d, T7c);
							    T7g = FMA(KP148335987, T7c, T7d);
							    T6K = FMA(KP250486960, T6A, T6H);
							    T6I = FNMS(KP250486960, T6H, T6A);
							    R1[WS(rs, 62)] = FMA(KP1_978353019, T7g, T7f);
							    R1[WS(rs, 30)] = FNMS(KP1_978353019, T7g, T7f);
							    R1[WS(rs, 46)] = FMA(KP1_978353019, T7e, T7b);
							    R1[WS(rs, 14)] = FNMS(KP1_978353019, T7e, T7b);
							    R1[WS(rs, 2)] = FMA(KP1_940062506, T6I, T6p);
							    R1[WS(rs, 34)] = FNMS(KP1_940062506, T6I, T6p);
							    R1[WS(rs, 18)] = FNMS(KP1_940062506, T6K, T6J);
							    R1[WS(rs, 50)] = FMA(KP1_940062506, T6K, T6J);
						       }
						  }
						  {
						       E T6N, T6Q, T6Z, T76;
						       T6R = FMA(KP1_763842528, T6M, T6L);
						       T6N = FNMS(KP1_763842528, T6M, T6L);
						       T6Q = FNMS(KP599376933, T6P, T6O);
						       T6S = FMA(KP599376933, T6O, T6P);
						       T77 = FMA(KP1_913880671, T6Y, T6V);
						       T6Z = FNMS(KP1_913880671, T6Y, T6V);
						       T76 = FNMS(KP741650546, T75, T72);
						       T78 = FMA(KP741650546, T72, T75);
						       R1[WS(rs, 42)] = FMA(KP1_715457220, T6Q, T6N);
						       R1[WS(rs, 10)] = FNMS(KP1_715457220, T6Q, T6N);
						       R1[WS(rs, 6)] = FMA(KP1_606415062, T76, T6Z);
						       R1[WS(rs, 38)] = FNMS(KP1_606415062, T76, T6Z);
						  }
					     }
					}
					{
					     E T9B, T97, T9C, T9e, T9T, T9t, Ta0, T9O, T9Z, T9L, T9Q, T9i, T9l, T9o, T9R;
					     E T9w;
					     {
						  E T9J, T9K, T9N, T9M, T9u, T9v;
						  {
						       E T93, T96, T9a, T9d;
						       T9J = FMA(KP1_847759065, T92, T91);
						       T93 = FNMS(KP1_847759065, T92, T91);
						       R1[WS(rs, 54)] = FMA(KP1_606415062, T78, T77);
						       R1[WS(rs, 22)] = FNMS(KP1_606415062, T78, T77);
						       R1[WS(rs, 58)] = FMA(KP1_715457220, T6S, T6R);
						       R1[WS(rs, 26)] = FNMS(KP1_715457220, T6S, T6R);
						       T96 = FNMS(KP198912367, T95, T94);
						       T9K = FMA(KP198912367, T94, T95);
						       T9N = FMA(KP923879532, T99, T98);
						       T9a = FNMS(KP923879532, T99, T98);
						       T9d = FNMS(KP923879532, T9c, T9b);
						       T9M = FMA(KP923879532, T9c, T9b);
						       T9B = FMA(KP1_961570560, T96, T93);
						       T97 = FNMS(KP1_961570560, T96, T93);
						       T9C = FMA(KP820678790, T9a, T9d);
						       T9e = FNMS(KP820678790, T9d, T9a);
						  }
						  T9T = FMA(KP923879532, T9s, T9r);
						  T9t = FNMS(KP923879532, T9s, T9r);
						  Ta0 = FMA(KP098491403, T9M, T9N);
						  T9O = FNMS(KP098491403, T9N, T9M);
						  T9Z = FMA(KP1_961570560, T9K, T9J);
						  T9L = FNMS(KP1_961570560, T9K, T9J);
						  T9Q = FMA(KP923879532, T9h, T9g);
						  T9i = FNMS(KP923879532, T9h, T9g);
						  T9l = FNMS(KP198912367, T9k, T9j);
						  T9u = FMA(KP198912367, T9j, T9k);
						  T9v = FMA(KP198912367, T9m, T9n);
						  T9o = FNMS(KP198912367, T9n, T9m);
						  T9R = T9u + T9v;
						  T9w = T9u - T9v;
					     }
					     {
						  E T9S, T9E, T9V, T9F;
						  {
						       E T9z, T9f, Ta3, T9x, T9U, T9p, Ta1, Ta5, Ta2, T9q;
						       T9z = FNMS(KP1_546020906, T9e, T97);
						       T9f = FMA(KP1_546020906, T9e, T97);
						       T9S = FNMS(KP980785280, T9R, T9Q);
						       Ta3 = FMA(KP980785280, T9R, T9Q);
						       T9E = FNMS(KP980785280, T9w, T9t);
						       T9x = FMA(KP980785280, T9w, T9t);
						       T9U = T9l - T9o;
						       T9p = T9l + T9o;
						       Ta1 = FNMS(KP1_990369453, Ta0, T9Z);
						       Ta5 = FMA(KP1_990369453, Ta0, T9Z);
						       T9V = FNMS(KP980785280, T9U, T9T);
						       Ta2 = FMA(KP980785280, T9U, T9T);
						       T9F = FMA(KP980785280, T9p, T9i);
						       T9q = FNMS(KP980785280, T9p, T9i);
						       {
							    E Ta4, Ta6, T9A, T9y;
							    Ta4 = FNMS(KP049126849, Ta3, Ta2);
							    Ta6 = FMA(KP049126849, Ta2, Ta3);
							    T9A = FMA(KP357805721, T9q, T9x);
							    T9y = FNMS(KP357805721, T9x, T9q);
							    R1[WS(rs, 63)] = FMA(KP1_997590912, Ta6, Ta5);
							    R1[WS(rs, 31)] = FNMS(KP1_997590912, Ta6, Ta5);
							    R1[WS(rs, 47)] = FMA(KP1_997590912, Ta4, Ta1);
							    R1[WS(rs, 15)] = FNMS(KP1_997590912, Ta4, Ta1);
							    R1[WS(rs, 3)] = FMA(KP1_883088130, T9y, T9f);
							    R1[WS(rs, 35)] = FNMS(KP1_883088130, T9y, T9f);
							    R1[WS(rs, 19)] = FNMS(KP1_883088130, T9A, T9z);
							    R1[WS(rs, 51)] = FMA(KP1_883088130, T9A, T9z);
						       }
						  }
						  {
						       E T9D, T9G, T9P, T9W;
						       T9H = FMA(KP1_546020906, T9C, T9B);
						       T9D = FNMS(KP1_546020906, T9C, T9B);
						       T9G = FNMS(KP472964775, T9F, T9E);
						       T9I = FMA(KP472964775, T9E, T9F);
						       T9X = FMA(KP1_990369453, T9O, T9L);
						       T9P = FNMS(KP1_990369453, T9O, T9L);
						       T9W = FNMS(KP906347169, T9V, T9S);
						       T9Y = FMA(KP906347169, T9S, T9V);
						       R1[WS(rs, 43)] = FMA(KP1_807978586, T9G, T9D);
						       R1[WS(rs, 11)] = FNMS(KP1_807978586, T9G, T9D);
						       R1[WS(rs, 7)] = FMA(KP1_481902250, T9W, T9P);
						       R1[WS(rs, 39)] = FNMS(KP1_481902250, T9W, T9P);
						  }
					     }
					}
				   }
			      }
			 }
		    }
	       }
	       R1[WS(rs, 55)] = FMA(KP1_481902250, T9Y, T9X);
	       R1[WS(rs, 23)] = FNMS(KP1_481902250, T9Y, T9X);
	       R1[WS(rs, 59)] = FMA(KP1_807978586, T9I, T9H);
	       R1[WS(rs, 27)] = FNMS(KP1_807978586, T9I, T9H);
	  }
     }
}

static const kr2c_desc desc = { 128, "r2cb_128", {416, 0, 540, 0}, &GENUS };

void X(codelet_r2cb_128) (planner *p) {
     X(kr2c_register) (p, r2cb_128, &desc);
}

#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_r2cb.native -compact -variables 4 -pipeline-latency 4 -sign 1 -n 128 -name r2cb_128 -include r2cb.h */

/*
 * This function contains 956 FP additions, 342 FP multiplications,
 * (or, 812 additions, 198 multiplications, 144 fused multiply/add),
 * 198 stack variables, 39 constants, and 256 memory accesses
 */
#include "r2cb.h"

static void r2cb_128(R *R0, R *R1, R *Cr, R *Ci, stride rs, stride csr, stride csi, INT v, INT ivs, INT ovs)
{
     DK(KP1_028205488, +1.028205488386443453187387677937631545216098241);
     DK(KP1_715457220, +1.715457220000544139804539968569540274084981599);
     DK(KP1_606415062, +1.606415062961289819613353025926283847759138854);
     DK(KP1_191398608, +1.191398608984866686934073057659939779023852677);
     DK(KP1_940062506, +1.940062506389087985207968414572200502913731924);
     DK(KP485960359, +0.485960359806527779896548324154942236641981567);
     DK(KP293460948, +0.293460948910723503317700259293435639412430633);
     DK(KP1_978353019, +1.978353019929561946903347476032486127967379067);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP555570233, +0.555570233019602224742830813948532874374937191);
     DK(KP855110186, +0.855110186860564188641933713777597068609157259);
     DK(KP1_807978586, +1.807978586246886663172400594461074097420264050);
     DK(KP1_481902250, +1.481902250709918182351233794990325459457910619);
     DK(KP1_343117909, +1.343117909694036801250753700854843606457501264);
     DK(KP1_883088130, +1.883088130366041556825018805199004714371179592);
     DK(KP673779706, +0.673779706784440101378506425238295140955533559);
     DK(KP098135348, +0.098135348654836028509909953885365316629490726);
     DK(KP1_997590912, +1.997590912410344785429543209518201388886407229);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP195090322, +0.195090322016128267848284868477022240927691618);
     DK(KP580569354, +0.580569354508924735272384751634790549382952557);
     DK(KP1_913880671, +1.913880671464417729871595773960539938965698411);
     DK(KP942793473, +0.942793473651995297112775251810508755314920638);
     DK(KP1_763842528, +1.763842528696710059425513727320776699016885241);
     DK(KP1_111140466, +1.111140466039204449485661627897065748749874382);
     DK(KP1_662939224, +1.662939224605090474157576755235811513477121624);
     DK(KP1_268786568, +1.268786568327290996430343226450986741351374190);
     DK(KP1_546020906, +1.546020906725473921621813219516939601942082586);
     DK(KP196034280, +0.196034280659121203988391127777283691722273346);
     DK(KP1_990369453, +1.990369453344393772489673906218959843150949737);
     DK(KP390180644, +0.390180644032256535696569736954044481855383236);
     DK(KP1_961570560, +1.961570560806460898252364472268478073947867462);
     DK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     DK(KP765366864, +0.765366864730179543456919968060797733522689125);
     DK(KP1_847759065, +1.847759065022573512256366378793576573644833252);
     DK(KP1_414213562, +1.414213562373095048801688724209698078569671875);
     DK(KP2_000000000, +2.000000000000000000000000000000000000000000000);
     {
	  INT i;
	  for (i = v; i > 0; i = i - 1, R0 = R0 + ovs, R1 = R1 + ovs, Cr = Cr + ivs, Ci = Ci + ivs, MAKE_VOLATILE_STRIDE(512, rs), MAKE_VOLATILE_STRIDE(512, csr), MAKE_VOLATILE_STRIDE(512, csi)) {
	       E Ta, T6q, T2a, T5k, T8x, Tbx, TcF, Ten, Th, T6r, T2j, T5l, T8E, Tby, TcI;
	       E Teo, Tx, T6t, TcM, Teq, TcP, Ter, T2t, T5n, T2C, T5o, T8Q, TbA, T8X, TbB;
	       E T6w, T7L, T1j, T6L, Tde, TeC, TdL, TeR, T3v, T5z, T4I, T5O, T9O, TbM, TaV;
	       E Tc1, T78, T7Z, TN, T6z, TcU, Teu, Td8, Tey, T2N, T5r, T3j, T5v, T9a, TbE;
	       E T9A, TbI, T6H, T7O, T1O, T7V, T48, T4u, Tds, TeG, T5E, T5K, Taf, TbP, Tdp;
	       E TeF, T6U, T72, Tam, TbQ, T23, T7U, T4r, T4v, Tdz, TeJ, T5H, T5L, Tay, TbS;
	       E Tdw, TeI, T6Z, T73, TaF, TbT, T1y, T75, Tdl, TeQ, TdI, TeD, T3O, T5N, T4z;
	       E T5A, Ta3, Tc0, TaO, TbN, T6O, T80, T12, T6E, Td1, Tex, Td5, Tev, T36, T5u;
	       E T3a, T5s, T9p, TbH, T9t, TbF, T6C, T7P;
	       {
		    E T5, T8s, T3, T8q, T9, T8u, T29, T8v, T6, T26;
		    {
			 E T4, T8r, T1, T2;
			 T4 = Cr[WS(csr, 32)];
			 T5 = KP2_000000000 * T4;
			 T8r = Ci[WS(csi, 32)];
			 T8s = KP2_000000000 * T8r;
			 T1 = Cr[0];
			 T2 = Cr[WS(csr, 64)];
			 T3 = T1 + T2;
			 T8q = T1 - T2;
			 {
			      E T7, T8, T27, T28;
			      T7 = Cr[WS(csr, 16)];
			      T8 = Cr[WS(csr, 48)];
			      T9 = KP2_000000000 * (T7 + T8);
			      T8u = T7 - T8;
			      T27 = Ci[WS(csi, 16)];
			      T28 = Ci[WS(csi, 48)];
			      T29 = KP2_000000000 * (T27 - T28);
			      T8v = T27 + T28;
			 }
		    }
		    T6 = T3 + T5;
		    Ta = T6 + T9;
		    T6q = T6 - T9;
		    T26 = T3 - T5;
		    T2a = T26 - T29;
		    T5k = T26 + T29;
		    {
			 E T8t, T8w, TcD, TcE;
			 T8t = T8q - T8s;
			 T8w = KP1_414213562 * (T8u - T8v);
			 T8x = T8t + T8w;
			 Tbx = T8t - T8w;
			 TcD = T8q + T8s;
			 TcE = KP1_414213562 * (T8u + T8v);
			 TcF = TcD - TcE;
			 Ten = TcD + TcE;
		    }
	       }
	       {
		    E Td, T8y, T2e, T8C, Tg, T8B, T2h, T8z, T2b, T2i;
		    {
			 E Tb, Tc, T2c, T2d;
			 Tb = Cr[WS(csr, 8)];
			 Tc = Cr[WS(csr, 56)];
			 Td = Tb + Tc;
			 T8y = Tb - Tc;
			 T2c = Ci[WS(csi, 8)];
			 T2d = Ci[WS(csi, 56)];
			 T2e = T2c - T2d;
			 T8C = T2c + T2d;
		    }
		    {
			 E Te, Tf, T2f, T2g;
			 Te = Cr[WS(csr, 40)];
			 Tf = Cr[WS(csr, 24)];
			 Tg = Te + Tf;
			 T8B = Te - Tf;
			 T2f = Ci[WS(csi, 40)];
			 T2g = Ci[WS(csi, 24)];
			 T2h = T2f - T2g;
			 T8z = T2f + T2g;
		    }
		    Th = KP2_000000000 * (Td + Tg);
		    T6r = KP2_000000000 * (T2h + T2e);
		    T2b = Td - Tg;
		    T2i = T2e - T2h;
		    T2j = KP1_414213562 * (T2b - T2i);
		    T5l = KP1_414213562 * (T2b + T2i);
		    {
			 E T8A, T8D, TcG, TcH;
			 T8A = T8y - T8z;
			 T8D = T8B + T8C;
			 T8E = FNMS(KP765366864, T8D, KP1_847759065 * T8A);
			 Tby = FMA(KP765366864, T8A, KP1_847759065 * T8D);
			 TcG = T8y + T8z;
			 TcH = T8C - T8B;
			 TcI = FNMS(KP1_847759065, TcH, KP765366864 * TcG);
			 Teo = FMA(KP1_847759065, TcG, KP765366864 * TcH);
		    }
	       }
	       {
		    E Tl, T8G, T2x, T8V, To, T8U, T2A, T8H, Tv, T8S, T2o, T8O, Ts, T8R, T2r;
		    E T8L;
		    {
			 E Tj, Tk, T2y, T2z;
			 Tj = Cr[WS(csr, 4)];
			 Tk = Cr[WS(csr, 60)];
			 Tl = Tj + Tk;
			 T8G = Tj - Tk;
			 {
			      E T2v, T2w, Tm, Tn;
			      T2v = Ci[WS(csi, 4)];
			      T2w = Ci[WS(csi, 60)];
			      T2x = T2v - T2w;
			      T8V = T2v + T2w;
			      Tm = Cr[WS(csr, 36)];
			      Tn = Cr[WS(csr, 28)];
			      To = Tm + Tn;
			      T8U = Tm - Tn;
			 }
			 T2y = Ci[WS(csi, 36)];
			 T2z = Ci[WS(csi, 28)];
			 T2A = T2y - T2z;
			 T8H = T2y + T2z;
			 {
			      E Tt, Tu, T8M, T2m, T2n, T8N;
			      Tt = Cr[WS(csr, 12)];
			      Tu = Cr[WS(csr, 52)];
			      T8M = Tt - Tu;
			      T2m = Ci[WS(csi, 52)];
			      T2n = Ci[WS(csi, 12)];
			      T8N = T2n + T2m;
			      Tv = Tt + Tu;
			      T8S = T8M + T8N;
			      T2o = T2m - T2n;
			      T8O = T8M - T8N;
			 }
			 {
			      E Tq, Tr, T8J, T2p, T2q, T8K;
			      Tq = Cr[WS(csr, 20)];
			      Tr = Cr[WS(csr, 44)];
			      T8J = Tq - Tr;
			      T2p = Ci[WS(csi, 20)];
			      T2q = Ci[WS(csi, 44)];
			      T8K = T2p + T2q;
			      Ts = Tq + Tr;
			      T8R = T8J + T8K;
			      T2r = T2p - T2q;
			      T8L = T8J - T8K;
			 }
		    }
		    {
			 E Tp, Tw, TcK, TcL;
			 Tp = Tl + To;
			 Tw = Ts + Tv;
			 Tx = KP2_000000000 * (Tp + Tw);
			 T6t = Tp - Tw;
			 TcK = T8G + T8H;
			 TcL = KP707106781 * (T8R + T8S);
			 TcM = TcK - TcL;
			 Teq = TcK + TcL;
		    }
		    {
			 E TcN, TcO, T2l, T2s;
			 TcN = KP707106781 * (T8L - T8O);
			 TcO = T8V - T8U;
			 TcP = TcN + TcO;
			 Ter = TcO - TcN;
			 T2l = Tl - To;
			 T2s = T2o - T2r;
			 T2t = T2l + T2s;
			 T5n = T2l - T2s;
		    }
		    {
			 E T2u, T2B, T8I, T8P;
			 T2u = Ts - Tv;
			 T2B = T2x - T2A;
			 T2C = T2u + T2B;
			 T5o = T2B - T2u;
			 T8I = T8G - T8H;
			 T8P = KP707106781 * (T8L + T8O);
			 T8Q = T8I + T8P;
			 TbA = T8I - T8P;
		    }
		    {
			 E T8T, T8W, T6u, T6v;
			 T8T = KP707106781 * (T8R - T8S);
			 T8W = T8U + T8V;
			 T8X = T8T + T8W;
			 TbB = T8W - T8T;
			 T6u = T2A + T2x;
			 T6v = T2r + T2o;
			 T6w = T6u - T6v;
			 T7L = KP2_000000000 * (T6v + T6u);
		    }
	       }
	       {
		    E T17, T9E, T4D, TaT, T1a, TaS, T4G, T9F, T1h, TaQ, T3q, T9M, T1e, TaP, T3t;
		    E T9J;
		    {
			 E T15, T16, T4E, T4F;
			 T15 = Cr[WS(csr, 1)];
			 T16 = Cr[WS(csr, 63)];
			 T17 = T15 + T16;
			 T9E = T15 - T16;
			 {
			      E T4B, T4C, T18, T19;
			      T4B = Ci[WS(csi, 1)];
			      T4C = Ci[WS(csi, 63)];
			      T4D = T4B - T4C;
			      TaT = T4B + T4C;
			      T18 = Cr[WS(csr, 33)];
			      T19 = Cr[WS(csr, 31)];
			      T1a = T18 + T19;
			      TaS = T18 - T19;
			 }
			 T4E = Ci[WS(csi, 33)];
			 T4F = Ci[WS(csi, 31)];
			 T4G = T4E - T4F;
			 T9F = T4E + T4F;
			 {
			      E T1f, T1g, T9K, T3o, T3p, T9L;
			      T1f = Cr[WS(csr, 15)];
			      T1g = Cr[WS(csr, 49)];
			      T9K = T1f - T1g;
			      T3o = Ci[WS(csi, 49)];
			      T3p = Ci[WS(csi, 15)];
			      T9L = T3p + T3o;
			      T1h = T1f + T1g;
			      TaQ = T9K + T9L;
			      T3q = T3o - T3p;
			      T9M = T9K - T9L;
			 }
			 {
			      E T1c, T1d, T9H, T3r, T3s, T9I;
			      T1c = Cr[WS(csr, 17)];
			      T1d = Cr[WS(csr, 47)];
			      T9H = T1c - T1d;
			      T3r = Ci[WS(csi, 17)];
			      T3s = Ci[WS(csi, 47)];
			      T9I = T3r + T3s;
			      T1e = T1c + T1d;
			      TaP = T9H + T9I;
			      T3t = T3r - T3s;
			      T9J = T9H - T9I;
			 }
		    }
		    {
			 E T1b, T1i, Tdc, Tdd;
			 T1b = T17 + T1a;
			 T1i = T1e + T1h;
			 T1j = T1b + T1i;
			 T6L = T1b - T1i;
			 Tdc = T9E + T9F;
			 Tdd = KP707106781 * (TaP + TaQ);
			 Tde = Tdc - Tdd;
			 TeC = Tdc + Tdd;
		    }
		    {
			 E TdJ, TdK, T3n, T3u;
			 TdJ = KP707106781 * (T9J - T9M);
			 TdK = TaT - TaS;
			 TdL = TdJ + TdK;
			 TeR = TdK - TdJ;
			 T3n = T17 - T1a;
			 T3u = T3q - T3t;
			 T3v = T3n + T3u;
			 T5z = T3n - T3u;
		    }
		    {
			 E T4A, T4H, T9G, T9N;
			 T4A = T1e - T1h;
			 T4H = T4D - T4G;
			 T4I = T4A + T4H;
			 T5O = T4H - T4A;
			 T9G = T9E - T9F;
			 T9N = KP707106781 * (T9J + T9M);
			 T9O = T9G + T9N;
			 TbM = T9G - T9N;
		    }
		    {
			 E TaR, TaU, T76, T77;
			 TaR = KP707106781 * (TaP - TaQ);
			 TaU = TaS + TaT;
			 TaV = TaR + TaU;
			 Tc1 = TaU - TaR;
			 T76 = T4G + T4D;
			 T77 = T3t + T3q;
			 T78 = T76 - T77;
			 T7Z = T77 + T76;
		    }
	       }
	       {
		    E TB, T90, T3e, T9y, TE, T9x, T3h, T91, TL, T9v, T2I, T98, TI, T9u, T2L;
		    E T95;
		    {
			 E Tz, TA, T3f, T3g;
			 Tz = Cr[WS(csr, 2)];
			 TA = Cr[WS(csr, 62)];
			 TB = Tz + TA;
			 T90 = Tz - TA;
			 {
			      E T3c, T3d, TC, TD;
			      T3c = Ci[WS(csi, 2)];
			      T3d = Ci[WS(csi, 62)];
			      T3e = T3c - T3d;
			      T9y = T3c + T3d;
			      TC = Cr[WS(csr, 34)];
			      TD = Cr[WS(csr, 30)];
			      TE = TC + TD;
			      T9x = TC - TD;
			 }
			 T3f = Ci[WS(csi, 34)];
			 T3g = Ci[WS(csi, 30)];
			 T3h = T3f - T3g;
			 T91 = T3f + T3g;
			 {
			      E TJ, TK, T96, T2G, T2H, T97;
			      TJ = Cr[WS(csr, 14)];
			      TK = Cr[WS(csr, 50)];
			      T96 = TJ - TK;
			      T2G = Ci[WS(csi, 50)];
			      T2H = Ci[WS(csi, 14)];
			      T97 = T2H + T2G;
			      TL = TJ + TK;
			      T9v = T96 + T97;
			      T2I = T2G - T2H;
			      T98 = T96 - T97;
			 }
			 {
			      E TG, TH, T93, T2J, T2K, T94;
			      TG = Cr[WS(csr, 18)];
			      TH = Cr[WS(csr, 46)];
			      T93 = TG - TH;
			      T2J = Ci[WS(csi, 18)];
			      T2K = Ci[WS(csi, 46)];
			      T94 = T2J + T2K;
			      TI = TG + TH;
			      T9u = T93 + T94;
			      T2L = T2J - T2K;
			      T95 = T93 - T94;
			 }
		    }
		    {
			 E TF, TM, TcS, TcT;
			 TF = TB + TE;
			 TM = TI + TL;
			 TN = TF + TM;
			 T6z = TF - TM;
			 TcS = T90 + T91;
			 TcT = KP707106781 * (T9u + T9v);
			 TcU = TcS - TcT;
			 Teu = TcS + TcT;
		    }
		    {
			 E Td6, Td7, T2F, T2M;
			 Td6 = KP707106781 * (T95 - T98);
			 Td7 = T9y - T9x;
			 Td8 = Td6 + Td7;
			 Tey = Td7 - Td6;
			 T2F = TB - TE;
			 T2M = T2I - T2L;
			 T2N = T2F + T2M;
			 T5r = T2F - T2M;
		    }
		    {
			 E T3b, T3i, T92, T99;
			 T3b = TI - TL;
			 T3i = T3e - T3h;
			 T3j = T3b + T3i;
			 T5v = T3i - T3b;
			 T92 = T90 - T91;
			 T99 = KP707106781 * (T95 + T98);
			 T9a = T92 + T99;
			 TbE = T92 - T99;
		    }
		    {
			 E T9w, T9z, T6F, T6G;
			 T9w = KP707106781 * (T9u - T9v);
			 T9z = T9x + T9y;
			 T9A = T9w + T9z;
			 TbI = T9z - T9w;
			 T6F = T3h + T3e;
			 T6G = T2L + T2I;
			 T6H = T6F - T6G;
			 T7O = T6G + T6F;
		    }
	       }
	       {
		    E T1G, Taj, T3Q, Ta5, T46, Tak, T6R, Ta6, T1N, Tag, Tah, T3X, T3Z, Taa, Tad;
		    E T6S, Tdn, Tdo;
		    {
			 E T1A, T1B, T1C, T1D, T1E, T1F;
			 T1A = Cr[WS(csr, 5)];
			 T1B = Cr[WS(csr, 59)];
			 T1C = T1A + T1B;
			 T1D = Cr[WS(csr, 37)];
			 T1E = Cr[WS(csr, 27)];
			 T1F = T1D + T1E;
			 T1G = T1C + T1F;
			 Taj = T1D - T1E;
			 T3Q = T1C - T1F;
			 Ta5 = T1A - T1B;
		    }
		    {
			 E T40, T41, T42, T43, T44, T45;
			 T40 = Ci[WS(csi, 5)];
			 T41 = Ci[WS(csi, 59)];
			 T42 = T40 - T41;
			 T43 = Ci[WS(csi, 37)];
			 T44 = Ci[WS(csi, 27)];
			 T45 = T43 - T44;
			 T46 = T42 - T45;
			 Tak = T40 + T41;
			 T6R = T45 + T42;
			 Ta6 = T43 + T44;
		    }
		    {
			 E T1J, Ta8, T3W, Ta9, T1M, Tab, T3T, Tac;
			 {
			      E T1H, T1I, T3U, T3V;
			      T1H = Cr[WS(csr, 21)];
			      T1I = Cr[WS(csr, 43)];
			      T1J = T1H + T1I;
			      Ta8 = T1H - T1I;
			      T3U = Ci[WS(csi, 21)];
			      T3V = Ci[WS(csi, 43)];
			      T3W = T3U - T3V;
			      Ta9 = T3U + T3V;
			 }
			 {
			      E T1K, T1L, T3R, T3S;
			      T1K = Cr[WS(csr, 11)];
			      T1L = Cr[WS(csr, 53)];
			      T1M = T1K + T1L;
			      Tab = T1K - T1L;
			      T3R = Ci[WS(csi, 53)];
			      T3S = Ci[WS(csi, 11)];
			      T3T = T3R - T3S;
			      Tac = T3S + T3R;
			 }
			 T1N = T1J + T1M;
			 Tag = Ta8 + Ta9;
			 Tah = Tab + Tac;
			 T3X = T3T - T3W;
			 T3Z = T1J - T1M;
			 Taa = Ta8 - Ta9;
			 Tad = Tab - Tac;
			 T6S = T3W + T3T;
		    }
		    T1O = T1G + T1N;
		    T7V = T6S + T6R;
		    {
			 E T3Y, T47, Tdq, Tdr;
			 T3Y = T3Q + T3X;
			 T47 = T3Z + T46;
			 T48 = FNMS(KP382683432, T47, KP923879532 * T3Y);
			 T4u = FMA(KP382683432, T3Y, KP923879532 * T47);
			 Tdq = KP707106781 * (Taa - Tad);
			 Tdr = Tak - Taj;
			 Tds = Tdq + Tdr;
			 TeG = Tdr - Tdq;
		    }
		    {
			 E T5C, T5D, Ta7, Tae;
			 T5C = T3Q - T3X;
			 T5D = T46 - T3Z;
			 T5E = FNMS(KP923879532, T5D, KP382683432 * T5C);
			 T5K = FMA(KP923879532, T5C, KP382683432 * T5D);
			 Ta7 = Ta5 - Ta6;
			 Tae = KP707106781 * (Taa + Tad);
			 Taf = Ta7 + Tae;
			 TbP = Ta7 - Tae;
		    }
		    Tdn = Ta5 + Ta6;
		    Tdo = KP707106781 * (Tag + Tah);
		    Tdp = Tdn - Tdo;
		    TeF = Tdn + Tdo;
		    {
			 E T6Q, T6T, Tai, Tal;
			 T6Q = T1G - T1N;
			 T6T = T6R - T6S;
			 T6U = T6Q - T6T;
			 T72 = T6Q + T6T;
			 Tai = KP707106781 * (Tag - Tah);
			 Tal = Taj + Tak;
			 Tam = Tai + Tal;
			 TbQ = Tal - Tai;
		    }
	       }
	       {
		    E T1V, TaC, T49, Tao, T4p, TaD, T6W, Tap, T22, Taz, TaA, T4g, T4i, Tat, Taw;
		    E T6X, Tdu, Tdv;
		    {
			 E T1P, T1Q, T1R, T1S, T1T, T1U;
			 T1P = Cr[WS(csr, 3)];
			 T1Q = Cr[WS(csr, 61)];
			 T1R = T1P + T1Q;
			 T1S = Cr[WS(csr, 29)];
			 T1T = Cr[WS(csr, 35)];
			 T1U = T1S + T1T;
			 T1V = T1R + T1U;
			 TaC = T1S - T1T;
			 T49 = T1R - T1U;
			 Tao = T1P - T1Q;
		    }
		    {
			 E T4j, T4k, T4l, T4m, T4n, T4o;
			 T4j = Ci[WS(csi, 61)];
			 T4k = Ci[WS(csi, 3)];
			 T4l = T4j - T4k;
			 T4m = Ci[WS(csi, 29)];
			 T4n = Ci[WS(csi, 35)];
			 T4o = T4m - T4n;
			 T4p = T4l - T4o;
			 TaD = T4k + T4j;
			 T6W = T4o + T4l;
			 Tap = T4m + T4n;
		    }
		    {
			 E T1Y, Tar, T4f, Tas, T21, Tau, T4c, Tav;
			 {
			      E T1W, T1X, T4d, T4e;
			      T1W = Cr[WS(csr, 13)];
			      T1X = Cr[WS(csr, 51)];
			      T1Y = T1W + T1X;
			      Tar = T1W - T1X;
			      T4d = Ci[WS(csi, 13)];
			      T4e = Ci[WS(csi, 51)];
			      T4f = T4d - T4e;
			      Tas = T4d + T4e;
			 }
			 {
			      E T1Z, T20, T4a, T4b;
			      T1Z = Cr[WS(csr, 19)];
			      T20 = Cr[WS(csr, 45)];
			      T21 = T1Z + T20;
			      Tau = T1Z - T20;
			      T4a = Ci[WS(csi, 45)];
			      T4b = Ci[WS(csi, 19)];
			      T4c = T4a - T4b;
			      Tav = T4b + T4a;
			 }
			 T22 = T1Y + T21;
			 Taz = Tar + Tas;
			 TaA = Tau + Tav;
			 T4g = T4c - T4f;
			 T4i = T1Y - T21;
			 Tat = Tar - Tas;
			 Taw = Tau - Tav;
			 T6X = T4f + T4c;
		    }
		    T23 = T1V + T22;
		    T7U = T6X + T6W;
		    {
			 E T4h, T4q, Tdx, Tdy;
			 T4h = T49 + T4g;
			 T4q = T4i + T4p;
			 T4r = FMA(KP923879532, T4h, KP382683432 * T4q);
			 T4v = FNMS(KP382683432, T4h, KP923879532 * T4q);
			 Tdx = KP707106781 * (Tat - Taw);
			 Tdy = TaC + TaD;
			 Tdz = Tdx - Tdy;
			 TeJ = Tdx + Tdy;
		    }
		    {
			 E T5F, T5G, Taq, Tax;
			 T5F = T49 - T4g;
			 T5G = T4p - T4i;
			 T5H = FMA(KP382683432, T5F, KP923879532 * T5G);
			 T5L = FNMS(KP923879532, T5F, KP382683432 * T5G);
			 Taq = Tao - Tap;
			 Tax = KP707106781 * (Tat + Taw);
			 Tay = Taq + Tax;
			 TbS = Taq - Tax;
		    }
		    Tdu = Tao + Tap;
		    Tdv = KP707106781 * (Taz + TaA);
		    Tdw = Tdu - Tdv;
		    TeI = Tdu + Tdv;
		    {
			 E T6V, T6Y, TaB, TaE;
			 T6V = T1V - T22;
			 T6Y = T6W - T6X;
			 T6Z = T6V + T6Y;
			 T73 = T6Y - T6V;
			 TaB = KP707106781 * (Taz - TaA);
			 TaE = TaC - TaD;
			 TaF = TaB + TaE;
			 TbT = TaE - TaB;
		    }
	       }
	       {
		    E T1m, T3z, T1p, T3C, T3w, T3D, Tdg, Tdf, T9U, T9R, T1t, T3I, T1w, T3L, T3F;
		    E T3M, Tdj, Tdi, Ta1, T9Y;
		    {
			 E T9P, T9T, T9S, T9Q;
			 {
			      E T1k, T1l, T3x, T3y;
			      T1k = Cr[WS(csr, 9)];
			      T1l = Cr[WS(csr, 55)];
			      T1m = T1k + T1l;
			      T9P = T1k - T1l;
			      T3x = Ci[WS(csi, 9)];
			      T3y = Ci[WS(csi, 55)];
			      T3z = T3x - T3y;
			      T9T = T3x + T3y;
			 }
			 {
			      E T1n, T1o, T3A, T3B;
			      T1n = Cr[WS(csr, 41)];
			      T1o = Cr[WS(csr, 23)];
			      T1p = T1n + T1o;
			      T9S = T1n - T1o;
			      T3A = Ci[WS(csi, 41)];
			      T3B = Ci[WS(csi, 23)];
			      T3C = T3A - T3B;
			      T9Q = T3A + T3B;
			 }
			 T3w = T1m - T1p;
			 T3D = T3z - T3C;
			 Tdg = T9T - T9S;
			 Tdf = T9P + T9Q;
			 T9U = T9S + T9T;
			 T9R = T9P - T9Q;
		    }
		    {
			 E T9W, Ta0, T9Z, T9X;
			 {
			      E T1r, T1s, T3G, T3H;
			      T1r = Cr[WS(csr, 7)];
			      T1s = Cr[WS(csr, 57)];
			      T1t = T1r + T1s;
			      T9W = T1r - T1s;
			      T3G = Ci[WS(csi, 57)];
			      T3H = Ci[WS(csi, 7)];
			      T3I = T3G - T3H;
			      Ta0 = T3H + T3G;
			 }
			 {
			      E T1u, T1v, T3J, T3K;
			      T1u = Cr[WS(csr, 25)];
			      T1v = Cr[WS(csr, 39)];
			      T1w = T1u + T1v;
			      T9Z = T1u - T1v;
			      T3J = Ci[WS(csi, 25)];
			      T3K = Ci[WS(csi, 39)];
			      T3L = T3J - T3K;
			      T9X = T3J + T3K;
			 }
			 T3F = T1t - T1w;
			 T3M = T3I - T3L;
			 Tdj = T9Z + Ta0;
			 Tdi = T9W + T9X;
			 Ta1 = T9Z - Ta0;
			 T9Y = T9W - T9X;
		    }
		    {
			 E T1q, T1x, Tdh, Tdk;
			 T1q = T1m + T1p;
			 T1x = T1t + T1w;
			 T1y = T1q + T1x;
			 T75 = T1q - T1x;
			 Tdh = FNMS(KP923879532, Tdg, KP382683432 * Tdf);
			 Tdk = FNMS(KP923879532, Tdj, KP382683432 * Tdi);
			 Tdl = Tdh + Tdk;
			 TeQ = Tdh - Tdk;
		    }
		    {
			 E TdG, TdH, T3E, T3N;
			 TdG = FMA(KP923879532, Tdf, KP382683432 * Tdg);
			 TdH = FMA(KP923879532, Tdi, KP382683432 * Tdj);
			 TdI = TdG - TdH;
			 TeD = TdG + TdH;
			 T3E = T3w - T3D;
			 T3N = T3F + T3M;
			 T3O = KP707106781 * (T3E + T3N);
			 T5N = KP707106781 * (T3E - T3N);
		    }
		    {
			 E T4x, T4y, T9V, Ta2;
			 T4x = T3w + T3D;
			 T4y = T3M - T3F;
			 T4z = KP707106781 * (T4x + T4y);
			 T5A = KP707106781 * (T4y - T4x);
			 T9V = FNMS(KP382683432, T9U, KP923879532 * T9R);
			 Ta2 = FMA(KP923879532, T9Y, KP382683432 * Ta1);
			 Ta3 = T9V + Ta2;
			 Tc0 = T9V - Ta2;
		    }
		    {
			 E TaM, TaN, T6M, T6N;
			 TaM = FMA(KP382683432, T9R, KP923879532 * T9U);
			 TaN = FNMS(KP382683432, T9Y, KP923879532 * Ta1);
			 TaO = TaM + TaN;
			 TbN = TaN - TaM;
			 T6M = T3L + T3I;
			 T6N = T3C + T3z;
			 T6O = T6M - T6N;
			 T80 = T6N + T6M;
		    }
	       }
	       {
		    E TQ, T2R, TT, T2U, T2O, T2V, TcW, TcV, T9g, T9d, TX, T30, T10, T33, T2X;
		    E T34, TcZ, TcY, T9n, T9k;
		    {
			 E T9b, T9f, T9e, T9c;
			 {
			      E TO, TP, T2P, T2Q;
			      TO = Cr[WS(csr, 10)];
			      TP = Cr[WS(csr, 54)];
			      TQ = TO + TP;
			      T9b = TO - TP;
			      T2P = Ci[WS(csi, 10)];
			      T2Q = Ci[WS(csi, 54)];
			      T2R = T2P - T2Q;
			      T9f = T2P + T2Q;
			 }
			 {
			      E TR, TS, T2S, T2T;
			      TR = Cr[WS(csr, 42)];
			      TS = Cr[WS(csr, 22)];
			      TT = TR + TS;
			      T9e = TR - TS;
			      T2S = Ci[WS(csi, 42)];
			      T2T = Ci[WS(csi, 22)];
			      T2U = T2S - T2T;
			      T9c = T2S + T2T;
			 }
			 T2O = TQ - TT;
			 T2V = T2R - T2U;
			 TcW = T9f - T9e;
			 TcV = T9b + T9c;
			 T9g = T9e + T9f;
			 T9d = T9b - T9c;
		    }
		    {
			 E T9i, T9m, T9l, T9j;
			 {
			      E TV, TW, T2Y, T2Z;
			      TV = Cr[WS(csr, 6)];
			      TW = Cr[WS(csr, 58)];
			      TX = TV + TW;
			      T9i = TV - TW;
			      T2Y = Ci[WS(csi, 58)];
			      T2Z = Ci[WS(csi, 6)];
			      T30 = T2Y - T2Z;
			      T9m = T2Z + T2Y;
			 }
			 {
			      E TY, TZ, T31, T32;
			      TY = Cr[WS(csr, 26)];
			      TZ = Cr[WS(csr, 38)];
			      T10 = TY + TZ;
			      T9l = TY - TZ;
			      T31 = Ci[WS(csi, 26)];
			      T32 = Ci[WS(csi, 38)];
			      T33 = T31 - T32;
			      T9j = T31 + T32;
			 }
			 T2X = TX - T10;
			 T34 = T30 - T33;
			 TcZ = T9l + T9m;
			 TcY = T9i + T9j;
			 T9n = T9l - T9m;
			 T9k = T9i - T9j;
		    }
		    {
			 E TU, T11, TcX, Td0;
			 TU = TQ + TT;
			 T11 = TX + T10;
			 T12 = TU + T11;
			 T6E = TU - T11;
			 TcX = FNMS(KP923879532, TcW, KP382683432 * TcV);
			 Td0 = FNMS(KP923879532, TcZ, KP382683432 * TcY);
			 Td1 = TcX + Td0;
			 Tex = TcX - Td0;
		    }
		    {
			 E Td3, Td4, T2W, T35;
			 Td3 = FMA(KP923879532, TcV, KP382683432 * TcW);
			 Td4 = FMA(KP923879532, TcY, KP382683432 * TcZ);
			 Td5 = Td3 - Td4;
			 Tev = Td3 + Td4;
			 T2W = T2O - T2V;
			 T35 = T2X + T34;
			 T36 = KP707106781 * (T2W + T35);
			 T5u = KP707106781 * (T2W - T35);
		    }
		    {
			 E T38, T39, T9h, T9o;
			 T38 = T2O + T2V;
			 T39 = T34 - T2X;
			 T3a = KP707106781 * (T38 + T39);
			 T5s = KP707106781 * (T39 - T38);
			 T9h = FNMS(KP382683432, T9g, KP923879532 * T9d);
			 T9o = FMA(KP923879532, T9k, KP382683432 * T9n);
			 T9p = T9h + T9o;
			 TbH = T9h - T9o;
		    }
		    {
			 E T9r, T9s, T6A, T6B;
			 T9r = FMA(KP382683432, T9d, KP923879532 * T9g);
			 T9s = FNMS(KP382683432, T9k, KP923879532 * T9n);
			 T9t = T9r + T9s;
			 TbF = T9s - T9r;
			 T6A = T33 + T30;
			 T6B = T2U + T2R;
			 T6C = T6A - T6B;
			 T7P = T6B + T6A;
		    }
	       }
	       {
		    E T13, T8f, Ty, T8e, T25, T8h, T8k, T8p, Ti, T14, T8o;
		    T13 = KP2_000000000 * (TN + T12);
		    T8f = KP2_000000000 * (T7P + T7O);
		    Ti = Ta + Th;
		    Ty = Ti + Tx;
		    T8e = Ti - Tx;
		    {
			 E T1z, T24, T8i, T8j;
			 T1z = T1j + T1y;
			 T24 = T1O + T23;
			 T25 = KP2_000000000 * (T1z + T24);
			 T8h = T1z - T24;
			 T8i = T80 + T7Z;
			 T8j = T7V + T7U;
			 T8k = T8i - T8j;
			 T8p = KP2_000000000 * (T8j + T8i);
		    }
		    T14 = Ty + T13;
		    R0[WS(rs, 32)] = T14 - T25;
		    R0[0] = T14 + T25;
		    T8o = Ty - T13;
		    R0[WS(rs, 16)] = T8o - T8p;
		    R0[WS(rs, 48)] = T8o + T8p;
		    {
			 E T8g, T8l, T8m, T8n;
			 T8g = T8e - T8f;
			 T8l = KP1_414213562 * (T8h - T8k);
			 R0[WS(rs, 40)] = T8g - T8l;
			 R0[WS(rs, 8)] = T8g + T8l;
			 T8m = T8e + T8f;
			 T8n = KP1_414213562 * (T8h + T8k);
			 R0[WS(rs, 24)] = T8m - T8n;
			 R0[WS(rs, 56)] = T8m + T8n;
		    }
	       }
	       {
		    E T7M, T86, T82, T8a, T7R, T87, T7X, T89, T7K, T7Y, T81;
		    T7K = Ta - Th;
		    T7M = T7K - T7L;
		    T86 = T7K + T7L;
		    T7Y = T1O - T23;
		    T81 = T7Z - T80;
		    T82 = T7Y + T81;
		    T8a = T81 - T7Y;
		    {
			 E T7N, T7Q, T7T, T7W;
			 T7N = TN - T12;
			 T7Q = T7O - T7P;
			 T7R = KP1_414213562 * (T7N - T7Q);
			 T87 = KP1_414213562 * (T7N + T7Q);
			 T7T = T1j - T1y;
			 T7W = T7U - T7V;
			 T7X = T7T + T7W;
			 T89 = T7T - T7W;
		    }
		    {
			 E T7S, T83, T8c, T8d;
			 T7S = T7M + T7R;
			 T83 = FNMS(KP765366864, T82, KP1_847759065 * T7X);
			 R0[WS(rs, 36)] = T7S - T83;
			 R0[WS(rs, 4)] = T7S + T83;
			 T8c = T86 + T87;
			 T8d = FMA(KP1_847759065, T89, KP765366864 * T8a);
			 R0[WS(rs, 28)] = T8c - T8d;
			 R0[WS(rs, 60)] = T8c + T8d;
		    }
		    {
			 E T84, T85, T88, T8b;
			 T84 = T7M - T7R;
			 T85 = FMA(KP765366864, T7X, KP1_847759065 * T82);
			 R0[WS(rs, 20)] = T84 - T85;
			 R0[WS(rs, 52)] = T84 + T85;
			 T88 = T86 - T87;
			 T8b = FNMS(KP1_847759065, T8a, KP765366864 * T89);
			 R0[WS(rs, 44)] = T88 - T8b;
			 R0[WS(rs, 12)] = T88 + T8b;
		    }
	       }
	       {
		    E T2E, T4O, T4K, T4S, T3l, T4P, T4t, T4R;
		    {
			 E T2k, T2D, T4w, T4J;
			 T2k = T2a + T2j;
			 T2D = FNMS(KP765366864, T2C, KP1_847759065 * T2t);
			 T2E = T2k + T2D;
			 T4O = T2k - T2D;
			 T4w = T4u + T4v;
			 T4J = T4z + T4I;
			 T4K = T4w + T4J;
			 T4S = T4J - T4w;
		    }
		    {
			 E T37, T3k, T3P, T4s;
			 T37 = T2N + T36;
			 T3k = T3a + T3j;
			 T3l = FNMS(KP390180644, T3k, KP1_961570560 * T37);
			 T4P = FMA(KP390180644, T37, KP1_961570560 * T3k);
			 T3P = T3v + T3O;
			 T4s = T48 + T4r;
			 T4t = T3P + T4s;
			 T4R = T3P - T4s;
		    }
		    {
			 E T3m, T4L, T4U, T4V;
			 T3m = T2E + T3l;
			 T4L = FNMS(KP196034280, T4K, KP1_990369453 * T4t);
			 R0[WS(rs, 33)] = T3m - T4L;
			 R0[WS(rs, 1)] = T3m + T4L;
			 T4U = T4O + T4P;
			 T4V = FMA(KP1_546020906, T4R, KP1_268786568 * T4S);
			 R0[WS(rs, 25)] = T4U - T4V;
			 R0[WS(rs, 57)] = T4U + T4V;
		    }
		    {
			 E T4M, T4N, T4Q, T4T;
			 T4M = T2E - T3l;
			 T4N = FMA(KP196034280, T4t, KP1_990369453 * T4K);
			 R0[WS(rs, 17)] = T4M - T4N;
			 R0[WS(rs, 49)] = T4M + T4N;
			 T4Q = T4O - T4P;
			 T4T = FNMS(KP1_546020906, T4S, KP1_268786568 * T4R);
			 R0[WS(rs, 41)] = T4Q - T4T;
			 R0[WS(rs, 9)] = T4Q + T4T;
		    }
	       }
	       {
		    E T6y, T7e, T7a, T7i, T6J, T7f, T71, T7h;
		    {
			 E T6s, T6x, T74, T79;
			 T6s = T6q - T6r;
			 T6x = KP1_414213562 * (T6t - T6w);
			 T6y = T6s + T6x;
			 T7e = T6s - T6x;
			 T74 = KP707106781 * (T72 + T73);
			 T79 = T75 + T78;
			 T7a = T74 + T79;
			 T7i = T79 - T74;
		    }
		    {
			 E T6D, T6I, T6P, T70;
			 T6D = T6z + T6C;
			 T6I = T6E + T6H;
			 T6J = FNMS(KP765366864, T6I, KP1_847759065 * T6D);
			 T7f = FMA(KP765366864, T6D, KP1_847759065 * T6I);
			 T6P = T6L + T6O;
			 T70 = KP707106781 * (T6U + T6Z);
			 T71 = T6P + T70;
			 T7h = T6P - T70;
		    }
		    {
			 E T6K, T7b, T7k, T7l;
			 T6K = T6y + T6J;
			 T7b = FNMS(KP390180644, T7a, KP1_961570560 * T71);
			 R0[WS(rs, 34)] = T6K - T7b;
			 R0[WS(rs, 2)] = T6K + T7b;
			 T7k = T7e + T7f;
			 T7l = FMA(KP1_662939224, T7h, KP1_111140466 * T7i);
			 R0[WS(rs, 26)] = T7k - T7l;
			 R0[WS(rs, 58)] = T7k + T7l;
		    }
		    {
			 E T7c, T7d, T7g, T7j;
			 T7c = T6y - T6J;
			 T7d = FMA(KP390180644, T71, KP1_961570560 * T7a);
			 R0[WS(rs, 18)] = T7c - T7d;
			 R0[WS(rs, 50)] = T7c + T7d;
			 T7g = T7e - T7f;
			 T7j = FNMS(KP1_662939224, T7i, KP1_111140466 * T7h);
			 R0[WS(rs, 42)] = T7g - T7j;
			 R0[WS(rs, 10)] = T7g + T7j;
		    }
	       }
	       {
		    E T4Y, T5c, T58, T5g, T51, T5d, T55, T5f;
		    {
			 E T4W, T4X, T56, T57;
			 T4W = T2a - T2j;
			 T4X = FMA(KP765366864, T2t, KP1_847759065 * T2C);
			 T4Y = T4W - T4X;
			 T5c = T4W + T4X;
			 T56 = T48 - T4r;
			 T57 = T4I - T4z;
			 T58 = T56 + T57;
			 T5g = T57 - T56;
		    }
		    {
			 E T4Z, T50, T53, T54;
			 T4Z = T2N - T36;
			 T50 = T3j - T3a;
			 T51 = FNMS(KP1_662939224, T50, KP1_111140466 * T4Z);
			 T5d = FMA(KP1_662939224, T4Z, KP1_111140466 * T50);
			 T53 = T3v - T3O;
			 T54 = T4v - T4u;
			 T55 = T53 + T54;
			 T5f = T53 - T54;
		    }
		    {
			 E T52, T59, T5i, T5j;
			 T52 = T4Y + T51;
			 T59 = FNMS(KP942793473, T58, KP1_763842528 * T55);
			 R0[WS(rs, 37)] = T52 - T59;
			 R0[WS(rs, 5)] = T52 + T59;
			 T5i = T5c + T5d;
			 T5j = FMA(KP1_913880671, T5f, KP580569354 * T5g);
			 R0[WS(rs, 29)] = T5i - T5j;
			 R0[WS(rs, 61)] = T5i + T5j;
		    }
		    {
			 E T5a, T5b, T5e, T5h;
			 T5a = T4Y - T51;
			 T5b = FMA(KP942793473, T55, KP1_763842528 * T58);
			 R0[WS(rs, 21)] = T5a - T5b;
			 R0[WS(rs, 53)] = T5a + T5b;
			 T5e = T5c - T5d;
			 T5h = FNMS(KP1_913880671, T5g, KP580569354 * T5f);
			 R0[WS(rs, 45)] = T5e - T5h;
			 R0[WS(rs, 13)] = T5e + T5h;
		    }
	       }
	       {
		    E T7o, T7C, T7y, T7G, T7r, T7D, T7v, T7F;
		    {
			 E T7m, T7n, T7w, T7x;
			 T7m = T6q + T6r;
			 T7n = KP1_414213562 * (T6t + T6w);
			 T7o = T7m - T7n;
			 T7C = T7m + T7n;
			 T7w = KP707106781 * (T6U - T6Z);
			 T7x = T78 - T75;
			 T7y = T7w + T7x;
			 T7G = T7x - T7w;
		    }
		    {
			 E T7p, T7q, T7t, T7u;
			 T7p = T6z - T6C;
			 T7q = T6H - T6E;
			 T7r = FNMS(KP1_847759065, T7q, KP765366864 * T7p);
			 T7D = FMA(KP1_847759065, T7p, KP765366864 * T7q);
			 T7t = T6L - T6O;
			 T7u = KP707106781 * (T73 - T72);
			 T7v = T7t + T7u;
			 T7F = T7t - T7u;
		    }
		    {
			 E T7s, T7z, T7I, T7J;
			 T7s = T7o + T7r;
			 T7z = FNMS(KP1_111140466, T7y, KP1_662939224 * T7v);
			 R0[WS(rs, 38)] = T7s - T7z;
			 R0[WS(rs, 6)] = T7s + T7z;
			 T7I = T7C + T7D;
			 T7J = FMA(KP1_961570560, T7F, KP390180644 * T7G);
			 R0[WS(rs, 30)] = T7I - T7J;
			 R0[WS(rs, 62)] = T7I + T7J;
		    }
		    {
			 E T7A, T7B, T7E, T7H;
			 T7A = T7o - T7r;
			 T7B = FMA(KP1_111140466, T7v, KP1_662939224 * T7y);
			 R0[WS(rs, 22)] = T7A - T7B;
			 R0[WS(rs, 54)] = T7A + T7B;
			 T7E = T7C - T7D;
			 T7H = FNMS(KP1_961570560, T7G, KP390180644 * T7F);
			 R0[WS(rs, 46)] = T7E - T7H;
			 R0[WS(rs, 14)] = T7E + T7H;
		    }
	       }
	       {
		    E T5q, T5U, T5Q, T5Y, T5x, T5V, T5J, T5X;
		    {
			 E T5m, T5p, T5M, T5P;
			 T5m = T5k - T5l;
			 T5p = FNMS(KP1_847759065, T5o, KP765366864 * T5n);
			 T5q = T5m + T5p;
			 T5U = T5m - T5p;
			 T5M = T5K + T5L;
			 T5P = T5N + T5O;
			 T5Q = T5M + T5P;
			 T5Y = T5P - T5M;
		    }
		    {
			 E T5t, T5w, T5B, T5I;
			 T5t = T5r + T5s;
			 T5w = T5u + T5v;
			 T5x = FNMS(KP1_111140466, T5w, KP1_662939224 * T5t);
			 T5V = FMA(KP1_111140466, T5t, KP1_662939224 * T5w);
			 T5B = T5z + T5A;
			 T5I = T5E + T5H;
			 T5J = T5B + T5I;
			 T5X = T5B - T5I;
		    }
		    {
			 E T5y, T5R, T60, T61;
			 T5y = T5q + T5x;
			 T5R = FNMS(KP580569354, T5Q, KP1_913880671 * T5J);
			 R0[WS(rs, 35)] = T5y - T5R;
			 R0[WS(rs, 3)] = T5y + T5R;
			 T60 = T5U + T5V;
			 T61 = FMA(KP1_763842528, T5X, KP942793473 * T5Y);
			 R0[WS(rs, 27)] = T60 - T61;
			 R0[WS(rs, 59)] = T60 + T61;
		    }
		    {
			 E T5S, T5T, T5W, T5Z;
			 T5S = T5q - T5x;
			 T5T = FMA(KP580569354, T5J, KP1_913880671 * T5Q);
			 R0[WS(rs, 19)] = T5S - T5T;
			 R0[WS(rs, 51)] = T5S + T5T;
			 T5W = T5U - T5V;
			 T5Z = FNMS(KP1_763842528, T5Y, KP942793473 * T5X);
			 R0[WS(rs, 43)] = T5W - T5Z;
			 R0[WS(rs, 11)] = T5W + T5Z;
		    }
	       }
	       {
		    E T64, T6i, T6e, T6m, T67, T6j, T6b, T6l;
		    {
			 E T62, T63, T6c, T6d;
			 T62 = T5k + T5l;
			 T63 = FMA(KP1_847759065, T5n, KP765366864 * T5o);
			 T64 = T62 - T63;
			 T6i = T62 + T63;
			 T6c = T5E - T5H;
			 T6d = T5O - T5N;
			 T6e = T6c + T6d;
			 T6m = T6d - T6c;
		    }
		    {
			 E T65, T66, T69, T6a;
			 T65 = T5r - T5s;
			 T66 = T5v - T5u;
			 T67 = FNMS(KP1_961570560, T66, KP390180644 * T65);
			 T6j = FMA(KP1_961570560, T65, KP390180644 * T66);
			 T69 = T5z - T5A;
			 T6a = T5L - T5K;
			 T6b = T69 + T6a;
			 T6l = T69 - T6a;
		    }
		    {
			 E T68, T6f, T6o, T6p;
			 T68 = T64 + T67;
			 T6f = FNMS(KP1_268786568, T6e, KP1_546020906 * T6b);
			 R0[WS(rs, 39)] = T68 - T6f;
			 R0[WS(rs, 7)] = T68 + T6f;
			 T6o = T6i + T6j;
			 T6p = FMA(KP1_990369453, T6l, KP196034280 * T6m);
			 R0[WS(rs, 31)] = T6o - T6p;
			 R0[WS(rs, 63)] = T6o + T6p;
		    }
		    {
			 E T6g, T6h, T6k, T6n;
			 T6g = T64 - T67;
			 T6h = FMA(KP1_268786568, T6b, KP1_546020906 * T6e);
			 R0[WS(rs, 23)] = T6g - T6h;
			 R0[WS(rs, 55)] = T6g + T6h;
			 T6k = T6i - T6j;
			 T6n = FNMS(KP1_990369453, T6m, KP196034280 * T6l);
			 R0[WS(rs, 47)] = T6k - T6n;
			 R0[WS(rs, 15)] = T6k + T6n;
		    }
	       }
	       {
		    E T8Z, Tb1, T9C, Tb2, Tbe, Tbq, Tbb, Tbp, TaX, Tbs, Tb5, Tbi, TaI, Tbt, Tb4;
		    E Tbl;
		    {
			 E T8F, T8Y, Tb9, Tba;
			 T8F = T8x + T8E;
			 T8Y = FNMS(KP390180644, T8X, KP1_961570560 * T8Q);
			 T8Z = T8F + T8Y;
			 Tb1 = T8F - T8Y;
			 {
			      E T9q, T9B, Tbc, Tbd;
			      T9q = T9a + T9p;
			      T9B = T9t + T9A;
			      T9C = FNMS(KP196034280, T9B, KP1_990369453 * T9q);
			      Tb2 = FMA(KP196034280, T9q, KP1_990369453 * T9B);
			      Tbc = T9a - T9p;
			      Tbd = T9A - T9t;
			      Tbe = FNMS(KP1_546020906, Tbd, KP1_268786568 * Tbc);
			      Tbq = FMA(KP1_546020906, Tbc, KP1_268786568 * Tbd);
			 }
			 Tb9 = T8x - T8E;
			 Tba = FMA(KP390180644, T8Q, KP1_961570560 * T8X);
			 Tbb = Tb9 - Tba;
			 Tbp = Tb9 + Tba;
			 {
			      E TaW, Tbg, TaL, Tbh, TaJ, TaK;
			      TaW = TaO + TaV;
			      Tbg = T9O - Ta3;
			      TaJ = FMA(KP195090322, Taf, KP980785280 * Tam);
			      TaK = FNMS(KP195090322, Tay, KP980785280 * TaF);
			      TaL = TaJ + TaK;
			      Tbh = TaK - TaJ;
			      TaX = TaL + TaW;
			      Tbs = Tbg - Tbh;
			      Tb5 = TaW - TaL;
			      Tbi = Tbg + Tbh;
			 }
			 {
			      E Ta4, Tbk, TaH, Tbj, Tan, TaG;
			      Ta4 = T9O + Ta3;
			      Tbk = TaV - TaO;
			      Tan = FNMS(KP195090322, Tam, KP980785280 * Taf);
			      TaG = FMA(KP980785280, Tay, KP195090322 * TaF);
			      TaH = Tan + TaG;
			      Tbj = Tan - TaG;
			      TaI = Ta4 + TaH;
			      Tbt = Tbk - Tbj;
			      Tb4 = Ta4 - TaH;
			      Tbl = Tbj + Tbk;
			 }
		    }
		    {
			 E T9D, TaY, Tbr, Tbu;
			 T9D = T8Z + T9C;
			 TaY = FNMS(KP098135348, TaX, KP1_997590912 * TaI);
			 R1[WS(rs, 32)] = T9D - TaY;
			 R1[0] = T9D + TaY;
			 Tbr = Tbp - Tbq;
			 Tbu = FNMS(KP1_883088130, Tbt, KP673779706 * Tbs);
			 R1[WS(rs, 44)] = Tbr - Tbu;
			 R1[WS(rs, 12)] = Tbr + Tbu;
		    }
		    {
			 E Tbv, Tbw, TaZ, Tb0;
			 Tbv = Tbp + Tbq;
			 Tbw = FMA(KP1_883088130, Tbs, KP673779706 * Tbt);
			 R1[WS(rs, 28)] = Tbv - Tbw;
			 R1[WS(rs, 60)] = Tbv + Tbw;
			 TaZ = T8Z - T9C;
			 Tb0 = FMA(KP098135348, TaI, KP1_997590912 * TaX);
			 R1[WS(rs, 16)] = TaZ - Tb0;
			 R1[WS(rs, 48)] = TaZ + Tb0;
		    }
		    {
			 E Tb3, Tb6, Tbf, Tbm;
			 Tb3 = Tb1 - Tb2;
			 Tb6 = FNMS(KP1_481902250, Tb5, KP1_343117909 * Tb4);
			 R1[WS(rs, 40)] = Tb3 - Tb6;
			 R1[WS(rs, 8)] = Tb3 + Tb6;
			 Tbf = Tbb + Tbe;
			 Tbm = FNMS(KP855110186, Tbl, KP1_807978586 * Tbi);
			 R1[WS(rs, 36)] = Tbf - Tbm;
			 R1[WS(rs, 4)] = Tbf + Tbm;
		    }
		    {
			 E Tbn, Tbo, Tb7, Tb8;
			 Tbn = Tbb - Tbe;
			 Tbo = FMA(KP855110186, Tbi, KP1_807978586 * Tbl);
			 R1[WS(rs, 20)] = Tbn - Tbo;
			 R1[WS(rs, 52)] = Tbn + Tbo;
			 Tb7 = Tb1 + Tb2;
			 Tb8 = FMA(KP1_481902250, Tb4, KP1_343117909 * Tb5);
			 R1[WS(rs, 24)] = Tb7 - Tb8;
			 R1[WS(rs, 56)] = Tb7 + Tb8;
		    }
	       }
	       {
		    E TcR, TdR, Tda, TdS, Te4, Teg, Te1, Tef, TdN, Tei, TdV, Te8, TdC, Tej, TdU;
		    E Teb;
		    {
			 E TcJ, TcQ, TdZ, Te0;
			 TcJ = TcF + TcI;
			 TcQ = FNMS(KP1_111140466, TcP, KP1_662939224 * TcM);
			 TcR = TcJ + TcQ;
			 TdR = TcJ - TcQ;
			 {
			      E Td2, Td9, Te2, Te3;
			      Td2 = TcU + Td1;
			      Td9 = Td5 + Td8;
			      Tda = FNMS(KP580569354, Td9, KP1_913880671 * Td2);
			      TdS = FMA(KP580569354, Td2, KP1_913880671 * Td9);
			      Te2 = TcU - Td1;
			      Te3 = Td8 - Td5;
			      Te4 = FNMS(KP1_763842528, Te3, KP942793473 * Te2);
			      Teg = FMA(KP1_763842528, Te2, KP942793473 * Te3);
			 }
			 TdZ = TcF - TcI;
			 Te0 = FMA(KP1_111140466, TcM, KP1_662939224 * TcP);
			 Te1 = TdZ - Te0;
			 Tef = TdZ + Te0;
			 {
			      E TdM, Te6, TdF, Te7, TdD, TdE;
			      TdM = TdI + TdL;
			      Te6 = Tde - Tdl;
			      TdD = FMA(KP555570233, Tdp, KP831469612 * Tds);
			      TdE = FNMS(KP555570233, Tdw, KP831469612 * Tdz);
			      TdF = TdD + TdE;
			      Te7 = TdE - TdD;
			      TdN = TdF + TdM;
			      Tei = Te6 - Te7;
			      TdV = TdM - TdF;
			      Te8 = Te6 + Te7;
			 }
			 {
			      E Tdm, Tea, TdB, Te9, Tdt, TdA;
			      Tdm = Tde + Tdl;
			      Tea = TdL - TdI;
			      Tdt = FNMS(KP555570233, Tds, KP831469612 * Tdp);
			      TdA = FMA(KP831469612, Tdw, KP555570233 * Tdz);
			      TdB = Tdt + TdA;
			      Te9 = Tdt - TdA;
			      TdC = Tdm + TdB;
			      Tej = Tea - Te9;
			      TdU = Tdm - TdB;
			      Teb = Te9 + Tea;
			 }
		    }
		    {
			 E Tdb, TdO, Teh, Tek;
			 Tdb = TcR + Tda;
			 TdO = FNMS(KP293460948, TdN, KP1_978353019 * TdC);
			 R1[WS(rs, 33)] = Tdb - TdO;
			 R1[WS(rs, 1)] = Tdb + TdO;
			 Teh = Tef - Teg;
			 Tek = FNMS(KP1_940062506, Tej, KP485960359 * Tei);
			 R1[WS(rs, 45)] = Teh - Tek;
			 R1[WS(rs, 13)] = Teh + Tek;
		    }
		    {
			 E Tel, Tem, TdP, TdQ;
			 Tel = Tef + Teg;
			 Tem = FMA(KP1_940062506, Tei, KP485960359 * Tej);
			 R1[WS(rs, 29)] = Tel - Tem;
			 R1[WS(rs, 61)] = Tel + Tem;
			 TdP = TcR - Tda;
			 TdQ = FMA(KP293460948, TdC, KP1_978353019 * TdN);
			 R1[WS(rs, 17)] = TdP - TdQ;
			 R1[WS(rs, 49)] = TdP + TdQ;
		    }
		    {
			 E TdT, TdW, Te5, Tec;
			 TdT = TdR - TdS;
			 TdW = FNMS(KP1_606415062, TdV, KP1_191398608 * TdU);
			 R1[WS(rs, 41)] = TdT - TdW;
			 R1[WS(rs, 9)] = TdT + TdW;
			 Te5 = Te1 + Te4;
			 Tec = FNMS(KP1_028205488, Teb, KP1_715457220 * Te8);
			 R1[WS(rs, 37)] = Te5 - Tec;
			 R1[WS(rs, 5)] = Te5 + Tec;
		    }
		    {
			 E Ted, Tee, TdX, TdY;
			 Ted = Te1 - Te4;
			 Tee = FMA(KP1_028205488, Te8, KP1_715457220 * Teb);
			 R1[WS(rs, 21)] = Ted - Tee;
			 R1[WS(rs, 53)] = Ted + Tee;
			 TdX = TdR + TdS;
			 TdY = FMA(KP1_606415062, TdU, KP1_191398608 * TdV);
			 R1[WS(rs, 25)] = TdX - TdY;
			 R1[WS(rs, 57)] = TdX + TdY;
		    }
	       }
	       {
		    E TbD, Tc7, TbK, Tc8, Tck, Tcw, Tch, Tcv, Tc3, Tcy, Tcb, Tco, TbW, Tcz, Tca;
		    E Tcr;
		    {
			 E Tbz, TbC, Tcf, Tcg;
			 Tbz = Tbx - Tby;
			 TbC = FNMS(KP1_662939224, TbB, KP1_111140466 * TbA);
			 TbD = Tbz + TbC;
			 Tc7 = Tbz - TbC;
			 {
			      E TbG, TbJ, Tci, Tcj;
			      TbG = TbE + TbF;
			      TbJ = TbH + TbI;
			      TbK = FNMS(KP942793473, TbJ, KP1_763842528 * TbG);
			      Tc8 = FMA(KP942793473, TbG, KP1_763842528 * TbJ);
			      Tci = TbE - TbF;
			      Tcj = TbI - TbH;
			      Tck = FNMS(KP1_913880671, Tcj, KP580569354 * Tci);
			      Tcw = FMA(KP1_913880671, Tci, KP580569354 * Tcj);
			 }
			 Tcf = Tbx + Tby;
			 Tcg = FMA(KP1_662939224, TbA, KP1_111140466 * TbB);
			 Tch = Tcf - Tcg;
			 Tcv = Tcf + Tcg;
			 {
			      E Tc2, Tcm, TbZ, Tcn, TbX, TbY;
			      Tc2 = Tc0 + Tc1;
			      Tcm = TbM - TbN;
			      TbX = FMA(KP831469612, TbP, KP555570233 * TbQ);
			      TbY = FNMS(KP831469612, TbS, KP555570233 * TbT);
			      TbZ = TbX + TbY;
			      Tcn = TbY - TbX;
			      Tc3 = TbZ + Tc2;
			      Tcy = Tcm - Tcn;
			      Tcb = Tc2 - TbZ;
			      Tco = Tcm + Tcn;
			 }
			 {
			      E TbO, Tcq, TbV, Tcp, TbR, TbU;
			      TbO = TbM + TbN;
			      Tcq = Tc1 - Tc0;
			      TbR = FNMS(KP831469612, TbQ, KP555570233 * TbP);
			      TbU = FMA(KP555570233, TbS, KP831469612 * TbT);
			      TbV = TbR + TbU;
			      Tcp = TbR - TbU;
			      TbW = TbO + TbV;
			      Tcz = Tcq - Tcp;
			      Tca = TbO - TbV;
			      Tcr = Tcp + Tcq;
			 }
		    }
		    {
			 E TbL, Tc4, Tcx, TcA;
			 TbL = TbD + TbK;
			 Tc4 = FNMS(KP485960359, Tc3, KP1_940062506 * TbW);
			 R1[WS(rs, 34)] = TbL - Tc4;
			 R1[WS(rs, 2)] = TbL + Tc4;
			 Tcx = Tcv - Tcw;
			 TcA = FNMS(KP1_978353019, Tcz, KP293460948 * Tcy);
			 R1[WS(rs, 46)] = Tcx - TcA;
			 R1[WS(rs, 14)] = Tcx + TcA;
		    }
		    {
			 E TcB, TcC, Tc5, Tc6;
			 TcB = Tcv + Tcw;
			 TcC = FMA(KP1_978353019, Tcy, KP293460948 * Tcz);
			 R1[WS(rs, 30)] = TcB - TcC;
			 R1[WS(rs, 62)] = TcB + TcC;
			 Tc5 = TbD - TbK;
			 Tc6 = FMA(KP485960359, TbW, KP1_940062506 * Tc3);
			 R1[WS(rs, 18)] = Tc5 - Tc6;
			 R1[WS(rs, 50)] = Tc5 + Tc6;
		    }
		    {
			 E Tc9, Tcc, Tcl, Tcs;
			 Tc9 = Tc7 - Tc8;
			 Tcc = FNMS(KP1_715457220, Tcb, KP1_028205488 * Tca);
			 R1[WS(rs, 42)] = Tc9 - Tcc;
			 R1[WS(rs, 10)] = Tc9 + Tcc;
			 Tcl = Tch + Tck;
			 Tcs = FNMS(KP1_191398608, Tcr, KP1_606415062 * Tco);
			 R1[WS(rs, 38)] = Tcl - Tcs;
			 R1[WS(rs, 6)] = Tcl + Tcs;
		    }
		    {
			 E Tct, Tcu, Tcd, Tce;
			 Tct = Tch - Tck;
			 Tcu = FMA(KP1_191398608, Tco, KP1_606415062 * Tcr);
			 R1[WS(rs, 22)] = Tct - Tcu;
			 R1[WS(rs, 54)] = Tct + Tcu;
			 Tcd = Tc7 + Tc8;
			 Tce = FMA(KP1_715457220, Tca, KP1_028205488 * Tcb);
			 R1[WS(rs, 26)] = Tcd - Tce;
			 R1[WS(rs, 58)] = Tcd + Tce;
		    }
	       }
	       {
		    E Tet, TeX, TeA, TeY, Tfa, Tfm, Tf7, Tfl, TeT, Tfo, Tf1, Tfe, TeM, Tfp, Tf0;
		    E Tfh;
		    {
			 E Tep, Tes, Tf5, Tf6;
			 Tep = Ten - Teo;
			 Tes = FNMS(KP1_961570560, Ter, KP390180644 * Teq);
			 Tet = Tep + Tes;
			 TeX = Tep - Tes;
			 {
			      E Tew, Tez, Tf8, Tf9;
			      Tew = Teu - Tev;
			      Tez = Tex + Tey;
			      TeA = FNMS(KP1_268786568, Tez, KP1_546020906 * Tew);
			      TeY = FMA(KP1_268786568, Tew, KP1_546020906 * Tez);
			      Tf8 = Teu + Tev;
			      Tf9 = Tey - Tex;
			      Tfa = FNMS(KP1_990369453, Tf9, KP196034280 * Tf8);
			      Tfm = FMA(KP1_990369453, Tf8, KP196034280 * Tf9);
			 }
			 Tf5 = Ten + Teo;
			 Tf6 = FMA(KP1_961570560, Teq, KP390180644 * Ter);
			 Tf7 = Tf5 - Tf6;
			 Tfl = Tf5 + Tf6;
			 {
			      E TeS, Tfc, TeP, Tfd, TeN, TeO;
			      TeS = TeQ + TeR;
			      Tfc = TeC + TeD;
			      TeN = FMA(KP980785280, TeF, KP195090322 * TeG);
			      TeO = FMA(KP980785280, TeI, KP195090322 * TeJ);
			      TeP = TeN - TeO;
			      Tfd = TeN + TeO;
			      TeT = TeP + TeS;
			      Tfo = Tfc + Tfd;
			      Tf1 = TeS - TeP;
			      Tfe = Tfc - Tfd;
			 }
			 {
			      E TeE, Tfg, TeL, Tff, TeH, TeK;
			      TeE = TeC - TeD;
			      Tfg = TeR - TeQ;
			      TeH = FNMS(KP980785280, TeG, KP195090322 * TeF);
			      TeK = FNMS(KP980785280, TeJ, KP195090322 * TeI);
			      TeL = TeH + TeK;
			      Tff = TeH - TeK;
			      TeM = TeE + TeL;
			      Tfp = Tfg - Tff;
			      Tf0 = TeE - TeL;
			      Tfh = Tff + Tfg;
			 }
		    }
		    {
			 E TeB, TeU, Tfn, Tfq;
			 TeB = Tet + TeA;
			 TeU = FNMS(KP673779706, TeT, KP1_883088130 * TeM);
			 R1[WS(rs, 35)] = TeB - TeU;
			 R1[WS(rs, 3)] = TeB + TeU;
			 Tfn = Tfl - Tfm;
			 Tfq = FNMS(KP1_997590912, Tfp, KP098135348 * Tfo);
			 R1[WS(rs, 47)] = Tfn - Tfq;
			 R1[WS(rs, 15)] = Tfn + Tfq;
		    }
		    {
			 E Tfr, Tfs, TeV, TeW;
			 Tfr = Tfl + Tfm;
			 Tfs = FMA(KP1_997590912, Tfo, KP098135348 * Tfp);
			 R1[WS(rs, 31)] = Tfr - Tfs;
			 R1[WS(rs, 63)] = Tfr + Tfs;
			 TeV = Tet - TeA;
			 TeW = FMA(KP673779706, TeM, KP1_883088130 * TeT);
			 R1[WS(rs, 19)] = TeV - TeW;
			 R1[WS(rs, 51)] = TeV + TeW;
		    }
		    {
			 E TeZ, Tf2, Tfb, Tfi;
			 TeZ = TeX - TeY;
			 Tf2 = FNMS(KP1_807978586, Tf1, KP855110186 * Tf0);
			 R1[WS(rs, 43)] = TeZ - Tf2;
			 R1[WS(rs, 11)] = TeZ + Tf2;
			 Tfb = Tf7 + Tfa;
			 Tfi = FNMS(KP1_343117909, Tfh, KP1_481902250 * Tfe);
			 R1[WS(rs, 39)] = Tfb - Tfi;
			 R1[WS(rs, 7)] = Tfb + Tfi;
		    }
		    {
			 E Tfj, Tfk, Tf3, Tf4;
			 Tfj = Tf7 - Tfa;
			 Tfk = FMA(KP1_343117909, Tfe, KP1_481902250 * Tfh);
			 R1[WS(rs, 23)] = Tfj - Tfk;
			 R1[WS(rs, 55)] = Tfj + Tfk;
			 Tf3 = TeX + TeY;
			 Tf4 = FMA(KP1_807978586, Tf0, KP855110186 * Tf1);
			 R1[WS(rs, 27)] = Tf3 - Tf4;
			 R1[WS(rs, 59)] = Tf3 + Tf4;
		    }
	       }
	  }
     }
}

static const kr2c_desc desc = { 128, "r2cb_128", {812, 198, 144, 0}, &GENUS };

void X(codelet_r2cb_128) (planner *p) {
     X(kr2c_register) (p, r2cb_128, &desc);
}

#endif				/* HAVE_FMA */
