/*
 * Copyright (c) 2003, 2007-14 Matteo Frigo
 * Copyright (c) 2003, 2007-14 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sex Out 30 16:36:01 CET 2015 */

#include "codelet-rdft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_hc2hc.native -fma -reorder-insns -schedule-for-pipeline -compact -variables 4 -pipeline-latency 4 -sign 1 -twiddle-log3 -precompute-twiddles -n 32 -dif -name hb2_32 -include hb.h */

/*
 * This function contains 488 FP additions, 350 FP multiplications,
 * (or, 236 additions, 98 multiplications, 252 fused multiply/add),
 * 204 stack variables, 7 constants, and 128 memory accesses
 */
#include "hb.h"

static void hb2_32(R *cr, R *ci, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP198912367, +0.198912367379658006911597622644676228597850501);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP668178637, +0.668178637919298919997757686523080761552472251);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP414213562, +0.414213562373095048801688724209698078569671875);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT m;
	  for (m = mb, W = W + ((mb - 1) * 8); m < me; m = m + 1, cr = cr + ms, ci = ci - ms, W = W + 8, MAKE_VOLATILE_STRIDE(64, rs)) {
	       E T5u, T6b, T6e, T5I, T66, T60, T5U, T5R, T67, T5L, T61, T5x, T5A, T5D, T5O;
	       E T62, T5V, T5P;
	       {
		    E T11, T14, T12, T37, T17, T1b, T39, T15, T7C, T8P, T8S, T7I, T98, T7e, T78;
		    E T8V, T3d, T3x, T3a, T3v, T9s, T3G, T4p, T5X, T16, T9m, T3y, T4b, T3C, T4g;
		    E T5Z, T1a, T4r, T3J, T2O, T1c, T4W, T4s, T3Y, T3K, T3l, T3e, T3i, T3q, T8K;
		    E T8E, T8m, T7S, T5k, T5e;
		    {
			 E T13, T3c, T38, T3F, T7B, T9l, T77, T7d, T9r, T7H;
			 T11 = W[2];
			 T14 = W[3];
			 T12 = W[4];
			 T37 = W[0];
			 T17 = W[6];
			 T1b = W[7];
			 T13 = T11 * T12;
			 T3c = T37 * T14;
			 T38 = T37 * T11;
			 T3F = T37 * T12;
			 T7B = T11 * T17;
			 T9l = T12 * T17;
			 T77 = T37 * T17;
			 T7d = T37 * T1b;
			 T9r = T12 * T1b;
			 T7H = T11 * T1b;
			 T39 = W[1];
			 T15 = W[5];
			 {
			      E T3I, T19, T5d, T3b, T18, T2N;
			      T7C = FMA(T14, T1b, T7B);
			      T8P = FNMS(T14, T1b, T7B);
			      T8S = FMA(T14, T17, T7H);
			      T7I = FNMS(T14, T17, T7H);
			      T98 = FNMS(T39, T17, T7d);
			      T7e = FMA(T39, T17, T7d);
			      T78 = FNMS(T39, T1b, T77);
			      T8V = FMA(T39, T1b, T77);
			      T3d = FMA(T39, T11, T3c);
			      T3x = FNMS(T39, T11, T3c);
			      T3a = FNMS(T39, T14, T38);
			      T3v = FMA(T39, T14, T38);
			      T9s = FNMS(T15, T17, T9r);
			      T3G = FNMS(T39, T15, T3F);
			      T4p = FMA(T39, T15, T3F);
			      T5X = FNMS(T14, T15, T13);
			      T16 = FMA(T14, T15, T13);
			      T3I = T37 * T15;
			      T19 = T11 * T15;
			      T5d = T3v * T12;
			      T3b = T3a * T12;
			      T9m = FMA(T15, T1b, T9l);
			      {
				   E T3w, T3B, T5t, T5H;
				   T3w = T3v * T17;
				   T3B = T3v * T1b;
				   T5t = T3a * T17;
				   T5H = T3a * T1b;
				   T3y = FNMS(T3x, T1b, T3w);
				   T4b = FMA(T3x, T1b, T3w);
				   T3C = FMA(T3x, T17, T3B);
				   T4g = FNMS(T3x, T17, T3B);
				   T5u = FMA(T3d, T1b, T5t);
				   T6b = FNMS(T3d, T1b, T5t);
				   T6e = FMA(T3d, T17, T5H);
				   T5I = FNMS(T3d, T17, T5H);
				   T18 = T16 * T17;
				   T2N = T16 * T1b;
				   T5Z = FMA(T14, T12, T19);
				   T1a = FNMS(T14, T12, T19);
			      }
			      {
				   E T3H, T3X, T4q, T4V, T5Y, T65;
				   T4q = T4p * T17;
				   T4V = T4p * T1b;
				   T4r = FNMS(T39, T12, T3I);
				   T3J = FMA(T39, T12, T3I);
				   T2O = FNMS(T1a, T17, T2N);
				   T1c = FMA(T1a, T1b, T18);
				   T3H = T3G * T17;
				   T4W = FNMS(T4r, T17, T4V);
				   T4s = FMA(T4r, T1b, T4q);
				   T3X = T3G * T1b;
				   T5Y = T5X * T17;
				   T65 = T5X * T1b;
				   T3Y = FNMS(T3J, T17, T3X);
				   T3K = FMA(T3J, T1b, T3H);
				   {
					E T8J, T8D, T3h, T5j, T8l, T7R;
					T3h = T3a * T15;
					T66 = FNMS(T5Z, T17, T65);
					T60 = FMA(T5Z, T1b, T5Y);
					T3l = FNMS(T3d, T15, T3b);
					T3e = FMA(T3d, T15, T3b);
					T3i = FNMS(T3d, T12, T3h);
					T3q = FMA(T3d, T12, T3h);
					T8J = T3l * T1b;
					T8D = T3l * T17;
					T5j = T3v * T15;
					T8l = T3e * T1b;
					T7R = T3e * T17;
					T8K = FNMS(T3q, T17, T8J);
					T8E = FMA(T3q, T1b, T8D);
					T8m = FNMS(T3i, T17, T8l);
					T7S = FMA(T3i, T1b, T7R);
					T5U = FNMS(T3x, T12, T5j);
					T5k = FMA(T3x, T12, T5j);
					T5e = FNMS(T3x, T15, T5d);
					T5R = FMA(T3x, T15, T5d);
				   }
			      }
			 }
		    }
		    {
			 E T6O, T6i, T7s, T7o, T6j, Tf, T8W, T7V, T99, T8p, T3L, T1t, T3Z, T2X, T5J;
			 E T4Z, T7t, T6W, T5v, T4v, TZ, T7x, T91, T9d, T28, T3S, T3R, T2h, T5B, T4Q;
			 E T8v, T8a, T5C, T4N, T6Z, T6J, TK, T7w, T2z, T3P, T94, T9c, T3O, T2I, T5y;
			 E T4J, T8u, T8h, T5z, T4G, T6Y, T6A, T6p, T6m, T6P, Tu, T9a, T82, T8X, T8s;
			 E T40, T1Q, T4y, T4B, T3M, T30, T5w, T52;
			 {
			      E T6B, T6I, T4L, T4M, T4t, T4u;
			      {
				   E T1d, T3, T2P, T6, T6Q, T2S, T6R, T1g, Td, T6U, T1i, Ta, T2V, T1r, T6T;
				   E T1l;
				   {
					E T4, T5, T2Q, T2R, T1, T2, T1e, T1f;
					T1 = cr[0];
					T2 = ci[WS(rs, 15)];
					{
					     E T6N, T6h, T7r, T7n;
					     T6N = T5R * T1b;
					     T6h = T5R * T17;
					     T7r = T5e * T1b;
					     T7n = T5e * T17;
					     T6O = FNMS(T5U, T17, T6N);
					     T6i = FMA(T5U, T1b, T6h);
					     T7s = FNMS(T5k, T17, T7r);
					     T7o = FMA(T5k, T1b, T7n);
					     T1d = T1 - T2;
					     T3 = T1 + T2;
					}
					T4 = cr[WS(rs, 8)];
					T5 = ci[WS(rs, 7)];
					T2Q = ci[WS(rs, 31)];
					T2R = cr[WS(rs, 16)];
					T1e = ci[WS(rs, 23)];
					T2P = T4 - T5;
					T6 = T4 + T5;
					T6Q = T2Q - T2R;
					T2S = T2Q + T2R;
					T1f = cr[WS(rs, 24)];
					{
					     E T1o, T1n, T1p, Tb, Tc;
					     Tb = ci[WS(rs, 3)];
					     Tc = cr[WS(rs, 12)];
					     T1o = ci[WS(rs, 19)];
					     T6R = T1e - T1f;
					     T1g = T1e + T1f;
					     T1n = Tb - Tc;
					     Td = Tb + Tc;
					     T1p = cr[WS(rs, 28)];
					     {
						  E T1j, T1k, T8, T9, T1q;
						  T8 = cr[WS(rs, 4)];
						  T9 = ci[WS(rs, 11)];
						  T1q = T1o + T1p;
						  T6U = T1o - T1p;
						  T1j = ci[WS(rs, 27)];
						  T1i = T8 - T9;
						  Ta = T8 + T9;
						  T1k = cr[WS(rs, 20)];
						  T2V = T1n + T1q;
						  T1r = T1n - T1q;
						  T6T = T1j - T1k;
						  T1l = T1j + T1k;
					     }
					}
				   }
				   {
					E T2U, T6V, T6S, T1h, T1s, T4Y, T4X, T2T, T2W;
					{
					     E T7T, T8o, T1m, T7U, T7, Te, T8n;
					     T7T = T3 - T6;
					     T7 = T3 + T6;
					     Te = Ta + Td;
					     T8o = Ta - Td;
					     T1m = T1i - T1l;
					     T2U = T1i + T1l;
					     T6j = T7 - Te;
					     Tf = T7 + Te;
					     T7U = T6U - T6T;
					     T6V = T6T + T6U;
					     T6S = T6Q + T6R;
					     T8n = T6Q - T6R;
					     T4t = T1d + T1g;
					     T1h = T1d - T1g;
					     T8W = T7T + T7U;
					     T7V = T7T - T7U;
					     T99 = T8o + T8n;
					     T8p = T8n - T8o;
					     T1s = T1m + T1r;
					     T4Y = T1m - T1r;
					}
					T4X = T2S - T2P;
					T2T = T2P + T2S;
					T2W = T2U - T2V;
					T4u = T2U + T2V;
					T3L = FMA(KP707106781, T1s, T1h);
					T1t = FNMS(KP707106781, T1s, T1h);
					T3Z = FMA(KP707106781, T2W, T2T);
					T2X = FNMS(KP707106781, T2W, T2T);
					T5J = FNMS(KP707106781, T4Y, T4X);
					T4Z = FMA(KP707106781, T4Y, T4X);
					T7t = T6S + T6V;
					T6W = T6S - T6V;
				   }
			      }
			      {
				   E T29, T1S, T1V, T87, TR, T2c, T84, T6E, T1X, TU, T1Y, T6G, T25, T22, TX;
				   E T1Z;
				   {
					E TO, TN, TP, TL, TM, T6C, T6D;
					TL = ci[0];
					TM = cr[WS(rs, 15)];
					TO = cr[WS(rs, 7)];
					T5v = FMA(KP707106781, T4u, T4t);
					T4v = FNMS(KP707106781, T4u, T4t);
					TN = TL + TM;
					T29 = TL - TM;
					TP = ci[WS(rs, 8)];
					{
					     E T2a, T2b, T1T, T1U, TQ;
					     T1T = ci[WS(rs, 16)];
					     T1U = cr[WS(rs, 31)];
					     TQ = TO + TP;
					     T1S = TO - TP;
					     T2a = ci[WS(rs, 24)];
					     T6C = T1T - T1U;
					     T1V = T1T + T1U;
					     T2b = cr[WS(rs, 23)];
					     T87 = TN - TQ;
					     TR = TN + TQ;
					     T2c = T2a + T2b;
					     T6D = T2a - T2b;
					}
					{
					     E T23, T24, TS, TT, TV, TW;
					     TS = cr[WS(rs, 3)];
					     TT = ci[WS(rs, 12)];
					     T84 = T6C - T6D;
					     T6E = T6C + T6D;
					     T23 = ci[WS(rs, 20)];
					     T1X = TS - TT;
					     TU = TS + TT;
					     T24 = cr[WS(rs, 27)];
					     TV = ci[WS(rs, 4)];
					     TW = cr[WS(rs, 11)];
					     T1Y = ci[WS(rs, 28)];
					     T6G = T23 - T24;
					     T25 = T23 + T24;
					     T22 = TV - TW;
					     TX = TV + TW;
					     T1Z = cr[WS(rs, 19)];
					}
				   }
				   {
					E T4O, T1W, T2f, T26, T8Z, T86, T2e, T21, T89, T90;
					{
					     E T85, TY, T6F, T20, T6H, T88;
					     T4O = T1S + T1V;
					     T1W = T1S - T1V;
					     T2f = T22 - T25;
					     T26 = T22 + T25;
					     T85 = TU - TX;
					     TY = TU + TX;
					     T6F = T1Y - T1Z;
					     T20 = T1Y + T1Z;
					     T8Z = T85 + T84;
					     T86 = T84 - T85;
					     T6B = TR - TY;
					     TZ = TR + TY;
					     T6H = T6F + T6G;
					     T88 = T6G - T6F;
					     T2e = T1X - T20;
					     T21 = T1X + T20;
					     T7x = T6E + T6H;
					     T6I = T6E - T6H;
					     T89 = T87 - T88;
					     T90 = T87 + T88;
					}
					{
					     E T4P, T2d, T27, T2g;
					     T2d = T29 - T2c;
					     T4L = T29 + T2c;
					     T4M = T21 + T26;
					     T27 = T21 - T26;
					     T2g = T2e + T2f;
					     T4P = T2e - T2f;
					     T91 = FNMS(KP414213562, T90, T8Z);
					     T9d = FMA(KP414213562, T8Z, T90);
					     T28 = FNMS(KP707106781, T27, T1W);
					     T3S = FMA(KP707106781, T27, T1W);
					     T3R = FMA(KP707106781, T2g, T2d);
					     T2h = FNMS(KP707106781, T2g, T2d);
					     T5B = FMA(KP707106781, T4P, T4O);
					     T4Q = FNMS(KP707106781, T4P, T4O);
					     T8v = FNMS(KP414213562, T86, T89);
					     T8a = FMA(KP414213562, T89, T86);
					}
				   }
			      }
			      {
				   E T6s, T6z, T4F, T4E;
				   {
					E T2A, T2j, TC, T8e, T2m, T2D, T6v, T8b, TG, T2o, TF, T6x, T2w, TH, T2p;
					E T2q;
					{
					     E Tw, Tx, Tz, TA, T6t, T6u;
					     Tw = cr[WS(rs, 1)];
					     T5C = FMA(KP707106781, T4M, T4L);
					     T4N = FNMS(KP707106781, T4M, T4L);
					     T6Z = T6I - T6B;
					     T6J = T6B + T6I;
					     Tx = ci[WS(rs, 14)];
					     Tz = cr[WS(rs, 9)];
					     TA = ci[WS(rs, 6)];
					     {
						  E T2k, Ty, TB, T2l, T2B, T2C;
						  T2k = ci[WS(rs, 30)];
						  T2A = Tw - Tx;
						  Ty = Tw + Tx;
						  T2j = Tz - TA;
						  TB = Tz + TA;
						  T2l = cr[WS(rs, 17)];
						  T2B = ci[WS(rs, 22)];
						  T2C = cr[WS(rs, 25)];
						  TC = Ty + TB;
						  T8e = Ty - TB;
						  T2m = T2k + T2l;
						  T6t = T2k - T2l;
						  T6u = T2B - T2C;
						  T2D = T2B + T2C;
					     }
					     {
						  E TD, TE, T2u, T2v;
						  TD = cr[WS(rs, 5)];
						  T6v = T6t + T6u;
						  T8b = T6t - T6u;
						  TE = ci[WS(rs, 10)];
						  T2u = ci[WS(rs, 18)];
						  T2v = cr[WS(rs, 29)];
						  TG = ci[WS(rs, 2)];
						  T2o = TD - TE;
						  TF = TD + TE;
						  T6x = T2u - T2v;
						  T2w = T2u + T2v;
						  TH = cr[WS(rs, 13)];
						  T2p = ci[WS(rs, 26)];
						  T2q = cr[WS(rs, 21)];
					     }
					}
					{
					     E T4H, T2n, T2G, T2F, T92, T8d, T2y, T93, T8g, T4I, T2E, T2H;
					     {
						  E T2x, T8c, T8f, T2s, T2t, TI;
						  T4H = T2m - T2j;
						  T2n = T2j + T2m;
						  T2t = TG - TH;
						  TI = TG + TH;
						  {
						       E T6w, T2r, TJ, T6y;
						       T6w = T2p - T2q;
						       T2r = T2p + T2q;
						       T2G = T2t - T2w;
						       T2x = T2t + T2w;
						       T8c = TF - TI;
						       TJ = TF + TI;
						       T6y = T6w + T6x;
						       T8f = T6x - T6w;
						       T2F = T2o - T2r;
						       T2s = T2o + T2r;
						       TK = TC + TJ;
						       T6s = TC - TJ;
						       T6z = T6v - T6y;
						       T7w = T6v + T6y;
						  }
						  T92 = T8c + T8b;
						  T8d = T8b - T8c;
						  T4F = T2s + T2x;
						  T2y = T2s - T2x;
						  T93 = T8e + T8f;
						  T8g = T8e - T8f;
					     }
					     T4E = T2A + T2D;
					     T2E = T2A - T2D;
					     T2H = T2F + T2G;
					     T4I = T2G - T2F;
					     T2z = FNMS(KP707106781, T2y, T2n);
					     T3P = FMA(KP707106781, T2y, T2n);
					     T94 = FMA(KP414213562, T93, T92);
					     T9c = FNMS(KP414213562, T92, T93);
					     T3O = FMA(KP707106781, T2H, T2E);
					     T2I = FNMS(KP707106781, T2H, T2E);
					     T5y = FMA(KP707106781, T4I, T4H);
					     T4J = FNMS(KP707106781, T4I, T4H);
					     T8u = FMA(KP414213562, T8d, T8g);
					     T8h = FNMS(KP414213562, T8g, T8d);
					}
				   }
				   {
					E T4x, T1O, Tm, T7Z, T80, T4w, T1J, T4A, T1D, Tt, T7X, T7W, T4z, T1y;
					{
					     E Tj, T1K, Ti, T6o, T1N, Tk, T1G, T1H;
					     {
						  E Tg, Th, T1L, T1M;
						  Tg = cr[WS(rs, 2)];
						  T5z = FMA(KP707106781, T4F, T4E);
						  T4G = FNMS(KP707106781, T4F, T4E);
						  T6Y = T6s + T6z;
						  T6A = T6s - T6z;
						  Th = ci[WS(rs, 13)];
						  T1L = ci[WS(rs, 21)];
						  T1M = cr[WS(rs, 26)];
						  Tj = cr[WS(rs, 10)];
						  T1K = Tg - Th;
						  Ti = Tg + Th;
						  T6o = T1L - T1M;
						  T1N = T1L + T1M;
						  Tk = ci[WS(rs, 5)];
						  T1G = ci[WS(rs, 29)];
						  T1H = cr[WS(rs, 18)];
					     }
					     {
						  E T1F, Tl, T6n, T1I;
						  T4x = T1K + T1N;
						  T1O = T1K - T1N;
						  T1F = Tj - Tk;
						  Tl = Tj + Tk;
						  T6n = T1G - T1H;
						  T1I = T1G + T1H;
						  Tm = Ti + Tl;
						  T7Z = Ti - Tl;
						  T80 = T6n - T6o;
						  T6p = T6n + T6o;
						  T4w = T1I - T1F;
						  T1J = T1F + T1I;
					     }
					}
					{
					     E Tq, T1z, Tp, T6l, T1C, Tr, T1v, T1w;
					     {
						  E Tn, To, T1A, T1B;
						  Tn = ci[WS(rs, 1)];
						  To = cr[WS(rs, 14)];
						  T1A = ci[WS(rs, 25)];
						  T1B = cr[WS(rs, 22)];
						  Tq = cr[WS(rs, 6)];
						  T1z = Tn - To;
						  Tp = Tn + To;
						  T6l = T1A - T1B;
						  T1C = T1A + T1B;
						  Tr = ci[WS(rs, 9)];
						  T1v = ci[WS(rs, 17)];
						  T1w = cr[WS(rs, 30)];
					     }
					     {
						  E T1u, Ts, T6k, T1x;
						  T4A = T1z + T1C;
						  T1D = T1z - T1C;
						  T1u = Tq - Tr;
						  Ts = Tq + Tr;
						  T6k = T1v - T1w;
						  T1x = T1v + T1w;
						  Tt = Tp + Ts;
						  T7X = Tp - Ts;
						  T7W = T6k - T6l;
						  T6m = T6k + T6l;
						  T4z = T1u + T1x;
						  T1y = T1u - T1x;
					     }
					}
					{
					     E T8r, T8q, T2Z, T1E, T1P, T2Y, T7Y, T81, T50, T51;
					     T8r = T7X + T7W;
					     T7Y = T7W - T7X;
					     T81 = T7Z + T80;
					     T8q = T7Z - T80;
					     T6P = Tm - Tt;
					     Tu = Tm + Tt;
					     T9a = T81 + T7Y;
					     T82 = T7Y - T81;
					     T2Z = FMA(KP414213562, T1y, T1D);
					     T1E = FNMS(KP414213562, T1D, T1y);
					     T1P = FMA(KP414213562, T1O, T1J);
					     T2Y = FNMS(KP414213562, T1J, T1O);
					     T8X = T8q + T8r;
					     T8s = T8q - T8r;
					     T40 = T1P + T1E;
					     T1Q = T1E - T1P;
					     T4y = FNMS(KP414213562, T4x, T4w);
					     T50 = FMA(KP414213562, T4w, T4x);
					     T51 = FMA(KP414213562, T4z, T4A);
					     T4B = FNMS(KP414213562, T4A, T4z);
					     T3M = T2Y + T2Z;
					     T30 = T2Y - T2Z;
					     T5w = T50 + T51;
					     T52 = T50 - T51;
					}
				   }
			      }
			 }
			 {
			      E T7D, T5K, T4C, T7K, T7J, T7E, T83, T8w, T8t, T8i, T6r, T70, T6X, T6K;
			      {
				   E T6q, T8Y, T9e, T9b, T95, T8L, T8Q, T8H, T8M, T8I, T8R;
				   {
					E Tv, T10, T7v, T7y, T7u;
					T7D = Tf - Tu;
					Tv = Tf + Tu;
					T7u = T6p + T6m;
					T6q = T6m - T6p;
					T5K = T4B - T4y;
					T4C = T4y + T4B;
					T10 = TK + TZ;
					T7K = TK - TZ;
					T7J = T7t - T7u;
					T7v = T7t + T7u;
					T7y = T7w + T7x;
					T7E = T7x - T7w;
					{
					     E T9t, T9x, T9p, T9u, T9q, T9y;
					     {
						  E T9n, T7z, T9o, T7A, T7q, T7p;
						  T8Y = FNMS(KP707106781, T8X, T8W);
						  T9n = FMA(KP707106781, T8X, T8W);
						  cr[0] = Tv + T10;
						  T7p = Tv - T10;
						  ci[0] = T7v + T7y;
						  T7z = T7v - T7y;
						  T9o = T9c + T9d;
						  T9e = T9c - T9d;
						  T7A = T7s * T7p;
						  T7q = T7o * T7p;
						  T9b = FNMS(KP707106781, T9a, T99);
						  T9t = FMA(KP707106781, T9a, T99);
						  T9x = FMA(KP923879532, T9o, T9n);
						  T9p = FNMS(KP923879532, T9o, T9n);
						  ci[WS(rs, 16)] = FMA(T7o, T7z, T7A);
						  cr[WS(rs, 16)] = FNMS(T7s, T7z, T7q);
						  T9u = T94 + T91;
						  T95 = T91 - T94;
					     }
					     T9q = T9m * T9p;
					     T9y = T3v * T9x;
					     {
						  E T8F, T9z, T9v, T8G, T9A, T9w;
						  T83 = FMA(KP707106781, T82, T7V);
						  T8F = FNMS(KP707106781, T82, T7V);
						  T9z = FMA(KP923879532, T9u, T9t);
						  T9v = FNMS(KP923879532, T9u, T9t);
						  T8G = T8u + T8v;
						  T8w = T8u - T8v;
						  T8t = FMA(KP707106781, T8s, T8p);
						  T8L = FNMS(KP707106781, T8s, T8p);
						  T9A = T3v * T9z;
						  cr[WS(rs, 2)] = FNMS(T3x, T9z, T9y);
						  T9w = T9m * T9v;
						  cr[WS(rs, 18)] = FNMS(T9s, T9v, T9q);
						  T8Q = FMA(KP923879532, T8G, T8F);
						  T8H = FNMS(KP923879532, T8G, T8F);
						  ci[WS(rs, 2)] = FMA(T3x, T9x, T9A);
						  ci[WS(rs, 18)] = FMA(T9s, T9p, T9w);
						  T8M = T8h + T8a;
						  T8i = T8a - T8h;
					     }
					     T8I = T8E * T8H;
					     T8R = T8P * T8Q;
					}
				   }
				   {
					E T7f, T7j, T7b, T7g, T7c, T7k;
					{
					     E T79, T8T, T8N, T7a, T8U, T8O;
					     T6r = T6j + T6q;
					     T79 = T6j - T6q;
					     T8T = FMA(KP923879532, T8M, T8L);
					     T8N = FNMS(KP923879532, T8M, T8L);
					     T7a = T6Z - T6Y;
					     T70 = T6Y + T6Z;
					     T6X = T6P + T6W;
					     T7f = T6W - T6P;
					     T8U = T8P * T8T;
					     cr[WS(rs, 30)] = FNMS(T8S, T8T, T8R);
					     T8O = T8E * T8N;
					     cr[WS(rs, 14)] = FNMS(T8K, T8N, T8I);
					     T7j = FMA(KP707106781, T7a, T79);
					     T7b = FNMS(KP707106781, T7a, T79);
					     ci[WS(rs, 30)] = FMA(T8S, T8Q, T8U);
					     ci[WS(rs, 14)] = FMA(T8K, T8H, T8O);
					     T7g = T6A - T6J;
					     T6K = T6A + T6J;
					}
					T7c = T78 * T7b;
					T7k = T5X * T7j;
					{
					     E T97, T9g, T9i, T9j, T9f, T9k, T9h, T96;
					     {
						  E T7l, T7h, T7m, T7i;
						  T7l = FMA(KP707106781, T7g, T7f);
						  T7h = FNMS(KP707106781, T7g, T7f);
						  T7m = T5X * T7l;
						  cr[WS(rs, 12)] = FNMS(T5Z, T7l, T7k);
						  T7i = T78 * T7h;
						  cr[WS(rs, 28)] = FNMS(T7e, T7h, T7c);
						  T9h = FMA(KP923879532, T95, T8Y);
						  T96 = FNMS(KP923879532, T95, T8Y);
						  ci[WS(rs, 12)] = FMA(T5Z, T7j, T7m);
						  ci[WS(rs, 28)] = FMA(T7e, T7b, T7i);
					     }
					     T97 = T8V * T96;
					     T9g = T98 * T96;
					     T9i = T3G * T9h;
					     T9j = FMA(KP923879532, T9e, T9b);
					     T9f = FNMS(KP923879532, T9e, T9b);
					     T9k = T3J * T9h;
					     cr[WS(rs, 10)] = FNMS(T3J, T9j, T9i);
					     ci[WS(rs, 26)] = FMA(T8V, T9f, T9g);
					     cr[WS(rs, 26)] = FNMS(T98, T9f, T97);
					     ci[WS(rs, 10)] = FMA(T3G, T9j, T9k);
					}
				   }
			      }
			      {
				   E T31, T3r, T1R, T3m, T33, T32, T3s, T2K, T8z, T8j;
				   {
					E T73, T6L, T75, T71;
					T73 = FMA(KP707106781, T6K, T6r);
					T6L = FNMS(KP707106781, T6K, T6r);
					T75 = FMA(KP707106781, T70, T6X);
					T71 = FNMS(KP707106781, T70, T6X);
					{
					     E T76, T74, T72, T6M;
					     T76 = T3d * T73;
					     T74 = T3a * T73;
					     T72 = T6O * T6L;
					     T6M = T6i * T6L;
					     ci[WS(rs, 4)] = FMA(T3a, T75, T76);
					     cr[WS(rs, 4)] = FNMS(T3d, T75, T74);
					     ci[WS(rs, 20)] = FMA(T6i, T71, T72);
					     cr[WS(rs, 20)] = FNMS(T6O, T71, T6M);
					}
				   }
				   {
					E T7N, T7F, T7P, T7L;
					T7N = T7D + T7E;
					T7F = T7D - T7E;
					T7P = T7K + T7J;
					T7L = T7J - T7K;
					{
					     E T7O, T7G, T7Q, T7M;
					     T7O = T4p * T7N;
					     T7G = T7C * T7F;
					     T7Q = T4p * T7P;
					     T7M = T7C * T7L;
					     cr[WS(rs, 8)] = FNMS(T4r, T7P, T7O);
					     cr[WS(rs, 24)] = FNMS(T7I, T7L, T7G);
					     ci[WS(rs, 8)] = FMA(T4r, T7N, T7Q);
					     ci[WS(rs, 24)] = FMA(T7I, T7F, T7M);
					}
				   }
				   T31 = FMA(KP923879532, T30, T2X);
				   T3r = FNMS(KP923879532, T30, T2X);
				   T8z = FMA(KP923879532, T8i, T83);
				   T8j = FNMS(KP923879532, T8i, T83);
				   {
					E T8B, T8x, T8C, T8A;
					T8B = FMA(KP923879532, T8w, T8t);
					T8x = FNMS(KP923879532, T8w, T8t);
					T8C = T1a * T8z;
					T8A = T16 * T8z;
					{
					     E T8y, T8k, T2i, T2J;
					     T8y = T8m * T8j;
					     T8k = T7S * T8j;
					     ci[WS(rs, 6)] = FMA(T16, T8B, T8C);
					     cr[WS(rs, 6)] = FNMS(T1a, T8B, T8A);
					     ci[WS(rs, 22)] = FMA(T7S, T8x, T8y);
					     cr[WS(rs, 22)] = FNMS(T8m, T8x, T8k);
					     T1R = FMA(KP923879532, T1Q, T1t);
					     T3m = FNMS(KP923879532, T1Q, T1t);
					     T33 = FNMS(KP668178637, T28, T2h);
					     T2i = FMA(KP668178637, T2h, T28);
					     T2J = FNMS(KP668178637, T2I, T2z);
					     T32 = FMA(KP668178637, T2z, T2I);
					     T3s = T2J + T2i;
					     T2K = T2i - T2J;
					}
				   }
				   {
					E T5l, T53, T5f, T4D, T4K, T4R, T56, T5g;
					T5l = FNMS(KP923879532, T52, T4Z);
					T53 = FMA(KP923879532, T52, T4Z);
					{
					     E T3t, T3D, T3f, T2L;
					     T3t = FNMS(KP831469612, T3s, T3r);
					     T3D = FMA(KP831469612, T3s, T3r);
					     T3f = FMA(KP831469612, T2K, T1R);
					     T2L = FNMS(KP831469612, T2K, T1R);
					     {
						  E T3n, T34, T3g, T2M;
						  T3n = T32 + T33;
						  T34 = T32 - T33;
						  T3g = T3e * T3f;
						  T2M = T1c * T2L;
						  {
						       E T3o, T3z, T3j, T35;
						       T3o = FNMS(KP831469612, T3n, T3m);
						       T3z = FMA(KP831469612, T3n, T3m);
						       T3j = FMA(KP831469612, T34, T31);
						       T35 = FNMS(KP831469612, T34, T31);
						       {
							    E T3u, T3p, T3E, T3A;
							    T3u = T3q * T3o;
							    T3p = T3l * T3o;
							    T3E = T3C * T3z;
							    T3A = T3y * T3z;
							    {
								 E T3k, T36, T54, T55;
								 T3k = T3e * T3j;
								 cr[WS(rs, 5)] = FNMS(T3i, T3j, T3g);
								 T36 = T1c * T35;
								 cr[WS(rs, 21)] = FNMS(T2O, T35, T2M);
								 ci[WS(rs, 13)] = FMA(T3l, T3t, T3u);
								 cr[WS(rs, 13)] = FNMS(T3q, T3t, T3p);
								 ci[WS(rs, 29)] = FMA(T3y, T3D, T3E);
								 cr[WS(rs, 29)] = FNMS(T3C, T3D, T3A);
								 ci[WS(rs, 5)] = FMA(T3i, T3f, T3k);
								 ci[WS(rs, 21)] = FMA(T2O, T2L, T36);
								 T5f = FMA(KP923879532, T4C, T4v);
								 T4D = FNMS(KP923879532, T4C, T4v);
								 T4K = FNMS(KP668178637, T4J, T4G);
								 T54 = FMA(KP668178637, T4G, T4J);
								 T55 = FMA(KP668178637, T4N, T4Q);
								 T4R = FNMS(KP668178637, T4Q, T4N);
								 T56 = T54 - T55;
								 T5g = T54 + T55;
							    }
						       }
						  }
					     }
					}
					{
					     E T4h, T41, T4c, T3N, T3Q, T3T, T44, T4d;
					     T4h = FNMS(KP923879532, T40, T3Z);
					     T41 = FMA(KP923879532, T40, T3Z);
					     {
						  E T57, T5b, T5h, T5p;
						  T57 = FNMS(KP831469612, T56, T53);
						  T5b = FMA(KP831469612, T56, T53);
						  T5h = FNMS(KP831469612, T5g, T5f);
						  T5p = FMA(KP831469612, T5g, T5f);
						  {
						       E T5m, T4S, T5i, T5q;
						       T5m = T4K - T4R;
						       T4S = T4K + T4R;
						       T5i = T5e * T5h;
						       T5q = T17 * T5p;
						       {
							    E T5n, T5r, T59, T4T;
							    T5n = FMA(KP831469612, T5m, T5l);
							    T5r = FNMS(KP831469612, T5m, T5l);
							    T59 = FMA(KP831469612, T4S, T4D);
							    T4T = FNMS(KP831469612, T4S, T4D);
							    {
								 E T5o, T5s, T5c, T5a;
								 T5o = T5e * T5n;
								 cr[WS(rs, 11)] = FNMS(T5k, T5n, T5i);
								 T5s = T17 * T5r;
								 cr[WS(rs, 27)] = FNMS(T1b, T5r, T5q);
								 T5c = T14 * T59;
								 T5a = T11 * T59;
								 {
								      E T58, T4U, T42, T43;
								      T58 = T4W * T4T;
								      T4U = T4s * T4T;
								      ci[WS(rs, 11)] = FMA(T5k, T5h, T5o);
								      ci[WS(rs, 27)] = FMA(T1b, T5p, T5s);
								      ci[WS(rs, 3)] = FMA(T11, T5b, T5c);
								      cr[WS(rs, 3)] = FNMS(T14, T5b, T5a);
								      ci[WS(rs, 19)] = FMA(T4s, T57, T58);
								      cr[WS(rs, 19)] = FNMS(T4W, T57, T4U);
								      T4c = FNMS(KP923879532, T3M, T3L);
								      T3N = FMA(KP923879532, T3M, T3L);
								      T3Q = FNMS(KP198912367, T3P, T3O);
								      T42 = FMA(KP198912367, T3O, T3P);
								      T43 = FNMS(KP198912367, T3R, T3S);
								      T3T = FMA(KP198912367, T3S, T3R);
								      T44 = T42 + T43;
								      T4d = T43 - T42;
								 }
							    }
						       }
						  }
					     }
					     T67 = FNMS(KP923879532, T5K, T5J);
					     T5L = FMA(KP923879532, T5K, T5J);
					     {
						  E T45, T49, T4e, T4l;
						  T45 = FNMS(KP980785280, T44, T41);
						  T49 = FMA(KP980785280, T44, T41);
						  T4e = FNMS(KP980785280, T4d, T4c);
						  T4l = FMA(KP980785280, T4d, T4c);
						  {
						       E T4i, T3U, T4f, T4m;
						       T4i = T3Q - T3T;
						       T3U = T3Q + T3T;
						       T4f = T4b * T4e;
						       T4m = T12 * T4l;
						       {
							    E T4j, T4n, T47, T3V;
							    T4j = FNMS(KP980785280, T4i, T4h);
							    T4n = FMA(KP980785280, T4i, T4h);
							    T47 = FMA(KP980785280, T3U, T3N);
							    T3V = FNMS(KP980785280, T3U, T3N);
							    {
								 E T4k, T4o, T4a, T48;
								 T4k = T4b * T4j;
								 cr[WS(rs, 25)] = FNMS(T4g, T4j, T4f);
								 T4o = T12 * T4n;
								 cr[WS(rs, 9)] = FNMS(T15, T4n, T4m);
								 T4a = T39 * T47;
								 T48 = T37 * T47;
								 {
								      E T46, T3W, T5M, T5N;
								      T46 = T3Y * T3V;
								      T3W = T3K * T3V;
								      ci[WS(rs, 25)] = FMA(T4g, T4e, T4k);
								      ci[WS(rs, 9)] = FMA(T15, T4l, T4o);
								      ci[WS(rs, 1)] = FMA(T37, T49, T4a);
								      cr[WS(rs, 1)] = FNMS(T39, T49, T48);
								      ci[WS(rs, 17)] = FMA(T3K, T45, T46);
								      cr[WS(rs, 17)] = FNMS(T3Y, T45, T3W);
								      T61 = FMA(KP923879532, T5w, T5v);
								      T5x = FNMS(KP923879532, T5w, T5v);
								      T5A = FNMS(KP198912367, T5z, T5y);
								      T5M = FMA(KP198912367, T5y, T5z);
								      T5N = FMA(KP198912367, T5B, T5C);
								      T5D = FNMS(KP198912367, T5C, T5B);
								      T5O = T5M - T5N;
								      T62 = T5M + T5N;
								 }
							    }
						       }
						  }
					     }
					}
				   }
			      }
			 }
		    }
	       }
	       T5V = FMA(KP980785280, T5O, T5L);
	       T5P = FNMS(KP980785280, T5O, T5L);
	       {
		    E T6c, T63, T5E, T68;
		    T6c = FMA(KP980785280, T62, T61);
		    T63 = FNMS(KP980785280, T62, T61);
		    T5E = T5A + T5D;
		    T68 = T5D - T5A;
		    {
			 E T64, T6d, T6f, T69;
			 T64 = T60 * T63;
			 T6d = T6b * T6c;
			 T6f = FNMS(KP980785280, T68, T67);
			 T69 = FMA(KP980785280, T68, T67);
			 {
			      E T5F, T5S, T6a, T6g;
			      T5F = FMA(KP980785280, T5E, T5x);
			      T5S = FNMS(KP980785280, T5E, T5x);
			      T6a = T60 * T69;
			      cr[WS(rs, 15)] = FNMS(T66, T69, T64);
			      T6g = T6b * T6f;
			      cr[WS(rs, 31)] = FNMS(T6e, T6f, T6d);
			      {
				   E T5W, T5T, T5Q, T5G;
				   T5W = T5U * T5S;
				   T5T = T5R * T5S;
				   T5Q = T5I * T5F;
				   T5G = T5u * T5F;
				   ci[WS(rs, 15)] = FMA(T66, T63, T6a);
				   ci[WS(rs, 31)] = FMA(T6e, T6c, T6g);
				   ci[WS(rs, 7)] = FMA(T5R, T5V, T5W);
				   cr[WS(rs, 7)] = FNMS(T5U, T5V, T5T);
				   ci[WS(rs, 23)] = FMA(T5u, T5P, T5Q);
				   cr[WS(rs, 23)] = FNMS(T5I, T5P, T5G);
			      }
			 }
		    }
	       }
	  }
     }
}

static const tw_instr twinstr[] = {
     {TW_CEXP, 1, 1},
     {TW_CEXP, 1, 3},
     {TW_CEXP, 1, 9},
     {TW_CEXP, 1, 27},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 32, "hb2_32", twinstr, &GENUS, {236, 98, 252, 0} };

void X(codelet_hb2_32) (planner *p) {
     X(khc2hc_register) (p, hb2_32, &desc);
}
#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_hc2hc.native -compact -variables 4 -pipeline-latency 4 -sign 1 -twiddle-log3 -precompute-twiddles -n 32 -dif -name hb2_32 -include hb.h */

/*
 * This function contains 488 FP additions, 280 FP multiplications,
 * (or, 376 additions, 168 multiplications, 112 fused multiply/add),
 * 160 stack variables, 7 constants, and 128 memory accesses
 */
#include "hb.h"

static void hb2_32(R *cr, R *ci, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP555570233, +0.555570233019602224742830813948532874374937191);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP195090322, +0.195090322016128267848284868477022240927691618);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT m;
	  for (m = mb, W = W + ((mb - 1) * 8); m < me; m = m + 1, cr = cr + ms, ci = ci - ms, W = W + 8, MAKE_VOLATILE_STRIDE(64, rs)) {
	       E T11, T14, T12, T15, T17, T2z, T2B, T1c, T18, T1d, T1g, T1k, T2F, T2L, T3t;
	       E T4H, T3h, T3V, T3b, T4v, T4T, T4X, T6t, T71, T6z, T75, T81, T8x, T8f, T8z;
	       E T2R, T2V, T8p, T8t, T4r, T4t, T53, T69, T3n, T3r, T7P, T7T, T4P, T4R, T6F;
	       E T6R, T1f, T2X, T1j, T2Y, T1l, T31, T2d, T2Z, T49, T4h, T4c, T4i, T4d, T4n;
	       E T4f, T4j;
	       {
		    E T2P, T3q, T2U, T3l, T2Q, T3p, T2T, T3m, T2D, T3g, T2K, T39, T2E, T3f, T2J;
		    E T3a;
		    {
			 E T13, T1b, T16, T1a;
			 T11 = W[0];
			 T14 = W[1];
			 T12 = W[2];
			 T15 = W[3];
			 T13 = T11 * T12;
			 T1b = T14 * T12;
			 T16 = T14 * T15;
			 T1a = T11 * T15;
			 T17 = T13 + T16;
			 T2z = T13 - T16;
			 T2B = T1a + T1b;
			 T1c = T1a - T1b;
			 T18 = W[4];
			 T2P = T12 * T18;
			 T3q = T14 * T18;
			 T2U = T15 * T18;
			 T3l = T11 * T18;
			 T1d = W[5];
			 T2Q = T15 * T1d;
			 T3p = T11 * T1d;
			 T2T = T12 * T1d;
			 T3m = T14 * T1d;
			 T1g = W[6];
			 T2D = T11 * T1g;
			 T3g = T15 * T1g;
			 T2K = T14 * T1g;
			 T39 = T12 * T1g;
			 T1k = W[7];
			 T2E = T14 * T1k;
			 T3f = T12 * T1k;
			 T2J = T11 * T1k;
			 T3a = T15 * T1k;
		    }
		    T2F = T2D - T2E;
		    T2L = T2J + T2K;
		    T3t = T39 - T3a;
		    T4H = T2J - T2K;
		    T3h = T3f - T3g;
		    T3V = T3f + T3g;
		    T3b = T39 + T3a;
		    T4v = T2D + T2E;
		    T4T = FMA(T18, T1g, T1d * T1k);
		    T4X = FNMS(T1d, T1g, T18 * T1k);
		    {
			 E T6r, T6s, T6x, T6y;
			 T6r = T17 * T1g;
			 T6s = T1c * T1k;
			 T6t = T6r - T6s;
			 T71 = T6r + T6s;
			 T6x = T17 * T1k;
			 T6y = T1c * T1g;
			 T6z = T6x + T6y;
			 T75 = T6x - T6y;
		    }
		    {
			 E T7Z, T80, T8d, T8e;
			 T7Z = T2z * T1g;
			 T80 = T2B * T1k;
			 T81 = T7Z + T80;
			 T8x = T7Z - T80;
			 T8d = T2z * T1k;
			 T8e = T2B * T1g;
			 T8f = T8d - T8e;
			 T8z = T8d + T8e;
			 T2R = T2P - T2Q;
			 T2V = T2T + T2U;
			 T8p = FMA(T2R, T1g, T2V * T1k);
			 T8t = FNMS(T2V, T1g, T2R * T1k);
		    }
		    T4r = T2P + T2Q;
		    T4t = T2T - T2U;
		    T53 = FMA(T4r, T1g, T4t * T1k);
		    T69 = FNMS(T4t, T1g, T4r * T1k);
		    T3n = T3l + T3m;
		    T3r = T3p - T3q;
		    T7P = FMA(T3n, T1g, T3r * T1k);
		    T7T = FNMS(T3r, T1g, T3n * T1k);
		    T4P = T3l - T3m;
		    T4R = T3p + T3q;
		    T6F = FMA(T4P, T1g, T4R * T1k);
		    T6R = FNMS(T4R, T1g, T4P * T1k);
		    {
			 E T19, T1e, T1h, T1i;
			 T19 = T17 * T18;
			 T1e = T1c * T1d;
			 T1f = T19 + T1e;
			 T2X = T19 - T1e;
			 T1h = T17 * T1d;
			 T1i = T1c * T18;
			 T1j = T1h - T1i;
			 T2Y = T1h + T1i;
		    }
		    T1l = FMA(T1f, T1g, T1j * T1k);
		    T31 = FNMS(T2Y, T1g, T2X * T1k);
		    T2d = FNMS(T1j, T1g, T1f * T1k);
		    T2Z = FMA(T2X, T1g, T2Y * T1k);
		    {
			 E T47, T48, T4a, T4b;
			 T47 = T2z * T18;
			 T48 = T2B * T1d;
			 T49 = T47 - T48;
			 T4h = T47 + T48;
			 T4a = T2z * T1d;
			 T4b = T2B * T18;
			 T4c = T4a + T4b;
			 T4i = T4a - T4b;
		    }
		    T4d = FMA(T49, T1g, T4c * T1k);
		    T4n = FNMS(T4i, T1g, T4h * T1k);
		    T4f = FNMS(T4c, T1g, T49 * T1k);
		    T4j = FMA(T4h, T1g, T4i * T1k);
	       }
	       {
		    E T56, T7b, T7C, T6c, Tf, T1m, T6f, T7c, T3Y, T4I, T2t, T32, T5d, T7D, T3w;
		    E T4w, Tu, T2e, T7g, T7F, T7j, T7G, T1B, T33, T3z, T40, T5l, T6i, T5s, T6h;
		    E T3C, T3Z, TK, T1D, T7v, T86, T7y, T85, T1S, T35, T3O, T4C, T5F, T6J, T5M;
		    E T6K, T3R, T4D, TZ, T1U, T7o, T89, T7r, T88, T29, T36, T3H, T4z, T5Y, T6M;
		    E T65, T6N, T3K, T4A;
		    {
			 E T3, T54, T2o, T58, T2r, T5b, T6, T6a, Ta, T57, T2h, T6b, T2k, T55, Td;
			 E T5a;
			 {
			      E T1, T2, T2m, T2n;
			      T1 = cr[0];
			      T2 = ci[WS(rs, 15)];
			      T3 = T1 + T2;
			      T54 = T1 - T2;
			      T2m = ci[WS(rs, 27)];
			      T2n = cr[WS(rs, 20)];
			      T2o = T2m - T2n;
			      T58 = T2m + T2n;
			 }
			 {
			      E T2p, T2q, T4, T5;
			      T2p = ci[WS(rs, 19)];
			      T2q = cr[WS(rs, 28)];
			      T2r = T2p - T2q;
			      T5b = T2p + T2q;
			      T4 = cr[WS(rs, 8)];
			      T5 = ci[WS(rs, 7)];
			      T6 = T4 + T5;
			      T6a = T4 - T5;
			 }
			 {
			      E T8, T9, T2f, T2g;
			      T8 = cr[WS(rs, 4)];
			      T9 = ci[WS(rs, 11)];
			      Ta = T8 + T9;
			      T57 = T8 - T9;
			      T2f = ci[WS(rs, 31)];
			      T2g = cr[WS(rs, 16)];
			      T2h = T2f - T2g;
			      T6b = T2f + T2g;
			 }
			 {
			      E T2i, T2j, Tb, Tc;
			      T2i = ci[WS(rs, 23)];
			      T2j = cr[WS(rs, 24)];
			      T2k = T2i - T2j;
			      T55 = T2i + T2j;
			      Tb = ci[WS(rs, 3)];
			      Tc = cr[WS(rs, 12)];
			      Td = Tb + Tc;
			      T5a = Tb - Tc;
			 }
			 {
			      E T7, Te, T2l, T2s;
			      T56 = T54 - T55;
			      T7b = T54 + T55;
			      T7C = T6b - T6a;
			      T6c = T6a + T6b;
			      T7 = T3 + T6;
			      Te = Ta + Td;
			      Tf = T7 + Te;
			      T1m = T7 - Te;
			      {
				   E T6d, T6e, T3W, T3X;
				   T6d = T57 + T58;
				   T6e = T5a + T5b;
				   T6f = KP707106781 * (T6d - T6e);
				   T7c = KP707106781 * (T6d + T6e);
				   T3W = T2h - T2k;
				   T3X = Ta - Td;
				   T3Y = T3W - T3X;
				   T4I = T3X + T3W;
			      }
			      T2l = T2h + T2k;
			      T2s = T2o + T2r;
			      T2t = T2l - T2s;
			      T32 = T2l + T2s;
			      {
				   E T59, T5c, T3u, T3v;
				   T59 = T57 - T58;
				   T5c = T5a - T5b;
				   T5d = KP707106781 * (T59 + T5c);
				   T7D = KP707106781 * (T59 - T5c);
				   T3u = T3 - T6;
				   T3v = T2r - T2o;
				   T3w = T3u - T3v;
				   T4w = T3u + T3v;
			      }
			 }
		    }
		    {
			 E Ti, T5p, T1w, T5n, T1z, T5q, Tl, T5m, Tp, T5i, T1p, T5g, T1s, T5j, Ts;
			 E T5f;
			 {
			      E Tg, Th, T1u, T1v;
			      Tg = cr[WS(rs, 2)];
			      Th = ci[WS(rs, 13)];
			      Ti = Tg + Th;
			      T5p = Tg - Th;
			      T1u = ci[WS(rs, 29)];
			      T1v = cr[WS(rs, 18)];
			      T1w = T1u - T1v;
			      T5n = T1u + T1v;
			 }
			 {
			      E T1x, T1y, Tj, Tk;
			      T1x = ci[WS(rs, 21)];
			      T1y = cr[WS(rs, 26)];
			      T1z = T1x - T1y;
			      T5q = T1x + T1y;
			      Tj = cr[WS(rs, 10)];
			      Tk = ci[WS(rs, 5)];
			      Tl = Tj + Tk;
			      T5m = Tj - Tk;
			 }
			 {
			      E Tn, To, T1n, T1o;
			      Tn = ci[WS(rs, 1)];
			      To = cr[WS(rs, 14)];
			      Tp = Tn + To;
			      T5i = Tn - To;
			      T1n = ci[WS(rs, 17)];
			      T1o = cr[WS(rs, 30)];
			      T1p = T1n - T1o;
			      T5g = T1n + T1o;
			 }
			 {
			      E T1q, T1r, Tq, Tr;
			      T1q = ci[WS(rs, 25)];
			      T1r = cr[WS(rs, 22)];
			      T1s = T1q - T1r;
			      T5j = T1q + T1r;
			      Tq = cr[WS(rs, 6)];
			      Tr = ci[WS(rs, 9)];
			      Ts = Tq + Tr;
			      T5f = Tq - Tr;
			 }
			 {
			      E Tm, Tt, T7e, T7f;
			      Tm = Ti + Tl;
			      Tt = Tp + Ts;
			      Tu = Tm + Tt;
			      T2e = Tm - Tt;
			      T7e = T5p + T5q;
			      T7f = T5n - T5m;
			      T7g = FNMS(KP923879532, T7f, KP382683432 * T7e);
			      T7F = FMA(KP382683432, T7f, KP923879532 * T7e);
			 }
			 {
			      E T7h, T7i, T1t, T1A;
			      T7h = T5i + T5j;
			      T7i = T5f + T5g;
			      T7j = FNMS(KP923879532, T7i, KP382683432 * T7h);
			      T7G = FMA(KP382683432, T7i, KP923879532 * T7h);
			      T1t = T1p + T1s;
			      T1A = T1w + T1z;
			      T1B = T1t - T1A;
			      T33 = T1A + T1t;
			 }
			 {
			      E T3x, T3y, T5h, T5k;
			      T3x = T1p - T1s;
			      T3y = Tp - Ts;
			      T3z = T3x - T3y;
			      T40 = T3y + T3x;
			      T5h = T5f - T5g;
			      T5k = T5i - T5j;
			      T5l = FNMS(KP382683432, T5k, KP923879532 * T5h);
			      T6i = FMA(KP382683432, T5h, KP923879532 * T5k);
			 }
			 {
			      E T5o, T5r, T3A, T3B;
			      T5o = T5m + T5n;
			      T5r = T5p - T5q;
			      T5s = FMA(KP923879532, T5o, KP382683432 * T5r);
			      T6h = FNMS(KP382683432, T5o, KP923879532 * T5r);
			      T3A = Ti - Tl;
			      T3B = T1w - T1z;
			      T3C = T3A + T3B;
			      T3Z = T3A - T3B;
			 }
		    }
		    {
			 E Ty, T5v, TB, T5G, T1J, T5w, T1G, T5H, TI, T5K, T1Q, T5D, TF, T5J, T1N;
			 E T5A;
			 {
			      E Tw, Tx, T1E, T1F;
			      Tw = cr[WS(rs, 1)];
			      Tx = ci[WS(rs, 14)];
			      Ty = Tw + Tx;
			      T5v = Tw - Tx;
			      {
				   E Tz, TA, T1H, T1I;
				   Tz = cr[WS(rs, 9)];
				   TA = ci[WS(rs, 6)];
				   TB = Tz + TA;
				   T5G = Tz - TA;
				   T1H = ci[WS(rs, 22)];
				   T1I = cr[WS(rs, 25)];
				   T1J = T1H - T1I;
				   T5w = T1H + T1I;
			      }
			      T1E = ci[WS(rs, 30)];
			      T1F = cr[WS(rs, 17)];
			      T1G = T1E - T1F;
			      T5H = T1E + T1F;
			      {
				   E TG, TH, T5B, T1O, T1P, T5C;
				   TG = ci[WS(rs, 2)];
				   TH = cr[WS(rs, 13)];
				   T5B = TG - TH;
				   T1O = ci[WS(rs, 18)];
				   T1P = cr[WS(rs, 29)];
				   T5C = T1O + T1P;
				   TI = TG + TH;
				   T5K = T5B + T5C;
				   T1Q = T1O - T1P;
				   T5D = T5B - T5C;
			      }
			      {
				   E TD, TE, T5y, T1L, T1M, T5z;
				   TD = cr[WS(rs, 5)];
				   TE = ci[WS(rs, 10)];
				   T5y = TD - TE;
				   T1L = ci[WS(rs, 26)];
				   T1M = cr[WS(rs, 21)];
				   T5z = T1L + T1M;
				   TF = TD + TE;
				   T5J = T5y + T5z;
				   T1N = T1L - T1M;
				   T5A = T5y - T5z;
			      }
			 }
			 {
			      E TC, TJ, T7t, T7u;
			      TC = Ty + TB;
			      TJ = TF + TI;
			      TK = TC + TJ;
			      T1D = TC - TJ;
			      T7t = T5H - T5G;
			      T7u = KP707106781 * (T5A - T5D);
			      T7v = T7t + T7u;
			      T86 = T7t - T7u;
			 }
			 {
			      E T7w, T7x, T1K, T1R;
			      T7w = T5v + T5w;
			      T7x = KP707106781 * (T5J + T5K);
			      T7y = T7w - T7x;
			      T85 = T7w + T7x;
			      T1K = T1G + T1J;
			      T1R = T1N + T1Q;
			      T1S = T1K - T1R;
			      T35 = T1K + T1R;
			 }
			 {
			      E T3M, T3N, T5x, T5E;
			      T3M = T1G - T1J;
			      T3N = TF - TI;
			      T3O = T3M - T3N;
			      T4C = T3N + T3M;
			      T5x = T5v - T5w;
			      T5E = KP707106781 * (T5A + T5D);
			      T5F = T5x - T5E;
			      T6J = T5x + T5E;
			 }
			 {
			      E T5I, T5L, T3P, T3Q;
			      T5I = T5G + T5H;
			      T5L = KP707106781 * (T5J - T5K);
			      T5M = T5I - T5L;
			      T6K = T5I + T5L;
			      T3P = Ty - TB;
			      T3Q = T1Q - T1N;
			      T3R = T3P - T3Q;
			      T4D = T3P + T3Q;
			 }
		    }
		    {
			 E TN, T5O, TQ, T5Z, T20, T5P, T1X, T60, TX, T63, T27, T5W, TU, T62, T24;
			 E T5T;
			 {
			      E TL, TM, T1V, T1W;
			      TL = ci[0];
			      TM = cr[WS(rs, 15)];
			      TN = TL + TM;
			      T5O = TL - TM;
			      {
				   E TO, TP, T1Y, T1Z;
				   TO = cr[WS(rs, 7)];
				   TP = ci[WS(rs, 8)];
				   TQ = TO + TP;
				   T5Z = TO - TP;
				   T1Y = ci[WS(rs, 24)];
				   T1Z = cr[WS(rs, 23)];
				   T20 = T1Y - T1Z;
				   T5P = T1Y + T1Z;
			      }
			      T1V = ci[WS(rs, 16)];
			      T1W = cr[WS(rs, 31)];
			      T1X = T1V - T1W;
			      T60 = T1V + T1W;
			      {
				   E TV, TW, T5U, T25, T26, T5V;
				   TV = ci[WS(rs, 4)];
				   TW = cr[WS(rs, 11)];
				   T5U = TV - TW;
				   T25 = ci[WS(rs, 20)];
				   T26 = cr[WS(rs, 27)];
				   T5V = T25 + T26;
				   TX = TV + TW;
				   T63 = T5U + T5V;
				   T27 = T25 - T26;
				   T5W = T5U - T5V;
			      }
			      {
				   E TS, TT, T5R, T22, T23, T5S;
				   TS = cr[WS(rs, 3)];
				   TT = ci[WS(rs, 12)];
				   T5R = TS - TT;
				   T22 = ci[WS(rs, 28)];
				   T23 = cr[WS(rs, 19)];
				   T5S = T22 + T23;
				   TU = TS + TT;
				   T62 = T5R + T5S;
				   T24 = T22 - T23;
				   T5T = T5R - T5S;
			      }
			 }
			 {
			      E TR, TY, T7m, T7n;
			      TR = TN + TQ;
			      TY = TU + TX;
			      TZ = TR + TY;
			      T1U = TR - TY;
			      T7m = KP707106781 * (T5T - T5W);
			      T7n = T5Z + T60;
			      T7o = T7m - T7n;
			      T89 = T7n + T7m;
			 }
			 {
			      E T7p, T7q, T21, T28;
			      T7p = T5O + T5P;
			      T7q = KP707106781 * (T62 + T63);
			      T7r = T7p - T7q;
			      T88 = T7p + T7q;
			      T21 = T1X + T20;
			      T28 = T24 + T27;
			      T29 = T21 - T28;
			      T36 = T21 + T28;
			 }
			 {
			      E T3F, T3G, T5Q, T5X;
			      T3F = T1X - T20;
			      T3G = TU - TX;
			      T3H = T3F - T3G;
			      T4z = T3G + T3F;
			      T5Q = T5O - T5P;
			      T5X = KP707106781 * (T5T + T5W);
			      T5Y = T5Q - T5X;
			      T6M = T5Q + T5X;
			 }
			 {
			      E T61, T64, T3I, T3J;
			      T61 = T5Z - T60;
			      T64 = KP707106781 * (T62 - T63);
			      T65 = T61 - T64;
			      T6N = T61 + T64;
			      T3I = TN - TQ;
			      T3J = T27 - T24;
			      T3K = T3I - T3J;
			      T4A = T3I + T3J;
			 }
		    }
		    {
			 E Tv, T10, T30, T34, T37, T38;
			 Tv = Tf + Tu;
			 T10 = TK + TZ;
			 T30 = Tv - T10;
			 T34 = T32 + T33;
			 T37 = T35 + T36;
			 T38 = T34 - T37;
			 cr[0] = Tv + T10;
			 ci[0] = T34 + T37;
			 cr[WS(rs, 16)] = FNMS(T31, T38, T2Z * T30);
			 ci[WS(rs, 16)] = FMA(T31, T30, T2Z * T38);
		    }
		    {
			 E T3e, T3o, T3k, T3s;
			 {
			      E T3c, T3d, T3i, T3j;
			      T3c = Tf - Tu;
			      T3d = T36 - T35;
			      T3e = T3c - T3d;
			      T3o = T3c + T3d;
			      T3i = T32 - T33;
			      T3j = TK - TZ;
			      T3k = T3i - T3j;
			      T3s = T3j + T3i;
			 }
			 cr[WS(rs, 24)] = FNMS(T3h, T3k, T3b * T3e);
			 ci[WS(rs, 24)] = FMA(T3b, T3k, T3h * T3e);
			 cr[WS(rs, 8)] = FNMS(T3r, T3s, T3n * T3o);
			 ci[WS(rs, 8)] = FMA(T3n, T3s, T3r * T3o);
		    }
		    {
			 E T1C, T2u, T2M, T2G, T2x, T2H, T2b, T2N;
			 T1C = T1m + T1B;
			 T2u = T2e + T2t;
			 T2M = T2t - T2e;
			 T2G = T1m - T1B;
			 {
			      E T2v, T2w, T1T, T2a;
			      T2v = T1D + T1S;
			      T2w = T29 - T1U;
			      T2x = KP707106781 * (T2v + T2w);
			      T2H = KP707106781 * (T2w - T2v);
			      T1T = T1D - T1S;
			      T2a = T1U + T29;
			      T2b = KP707106781 * (T1T + T2a);
			      T2N = KP707106781 * (T1T - T2a);
			 }
			 {
			      E T2c, T2y, T2S, T2W;
			      T2c = T1C - T2b;
			      T2y = T2u - T2x;
			      cr[WS(rs, 20)] = FNMS(T2d, T2y, T1l * T2c);
			      ci[WS(rs, 20)] = FMA(T2d, T2c, T1l * T2y);
			      T2S = T2G + T2H;
			      T2W = T2M + T2N;
			      cr[WS(rs, 12)] = FNMS(T2V, T2W, T2R * T2S);
			      ci[WS(rs, 12)] = FMA(T2R, T2W, T2V * T2S);
			 }
			 {
			      E T2A, T2C, T2I, T2O;
			      T2A = T1C + T2b;
			      T2C = T2u + T2x;
			      cr[WS(rs, 4)] = FNMS(T2B, T2C, T2z * T2A);
			      ci[WS(rs, 4)] = FMA(T2B, T2A, T2z * T2C);
			      T2I = T2G - T2H;
			      T2O = T2M - T2N;
			      cr[WS(rs, 28)] = FNMS(T2L, T2O, T2F * T2I);
			      ci[WS(rs, 28)] = FMA(T2F, T2O, T2L * T2I);
			 }
		    }
		    {
			 E T4y, T4U, T4K, T4Y, T4F, T4Z, T4N, T4V, T4x, T4J;
			 T4x = KP707106781 * (T3Z + T40);
			 T4y = T4w - T4x;
			 T4U = T4w + T4x;
			 T4J = KP707106781 * (T3C + T3z);
			 T4K = T4I - T4J;
			 T4Y = T4I + T4J;
			 {
			      E T4B, T4E, T4L, T4M;
			      T4B = FNMS(KP382683432, T4A, KP923879532 * T4z);
			      T4E = FMA(KP923879532, T4C, KP382683432 * T4D);
			      T4F = T4B - T4E;
			      T4Z = T4E + T4B;
			      T4L = FNMS(KP382683432, T4C, KP923879532 * T4D);
			      T4M = FMA(KP382683432, T4z, KP923879532 * T4A);
			      T4N = T4L - T4M;
			      T4V = T4L + T4M;
			 }
			 {
			      E T4G, T4O, T51, T52;
			      T4G = T4y - T4F;
			      T4O = T4K - T4N;
			      cr[WS(rs, 26)] = FNMS(T4H, T4O, T4v * T4G);
			      ci[WS(rs, 26)] = FMA(T4H, T4G, T4v * T4O);
			      T51 = T4U + T4V;
			      T52 = T4Y + T4Z;
			      cr[WS(rs, 2)] = FNMS(T1c, T52, T17 * T51);
			      ci[WS(rs, 2)] = FMA(T17, T52, T1c * T51);
			 }
			 {
			      E T4Q, T4S, T4W, T50;
			      T4Q = T4y + T4F;
			      T4S = T4K + T4N;
			      cr[WS(rs, 10)] = FNMS(T4R, T4S, T4P * T4Q);
			      ci[WS(rs, 10)] = FMA(T4R, T4Q, T4P * T4S);
			      T4W = T4U - T4V;
			      T50 = T4Y - T4Z;
			      cr[WS(rs, 18)] = FNMS(T4X, T50, T4T * T4W);
			      ci[WS(rs, 18)] = FMA(T4T, T50, T4X * T4W);
			 }
		    }
		    {
			 E T3E, T4k, T42, T4o, T3T, T4p, T45, T4l, T3D, T41;
			 T3D = KP707106781 * (T3z - T3C);
			 T3E = T3w - T3D;
			 T4k = T3w + T3D;
			 T41 = KP707106781 * (T3Z - T40);
			 T42 = T3Y - T41;
			 T4o = T3Y + T41;
			 {
			      E T3L, T3S, T43, T44;
			      T3L = FNMS(KP923879532, T3K, KP382683432 * T3H);
			      T3S = FMA(KP382683432, T3O, KP923879532 * T3R);
			      T3T = T3L - T3S;
			      T4p = T3S + T3L;
			      T43 = FNMS(KP923879532, T3O, KP382683432 * T3R);
			      T44 = FMA(KP923879532, T3H, KP382683432 * T3K);
			      T45 = T43 - T44;
			      T4l = T43 + T44;
			 }
			 {
			      E T3U, T46, T4s, T4u;
			      T3U = T3E - T3T;
			      T46 = T42 - T45;
			      cr[WS(rs, 30)] = FNMS(T3V, T46, T3t * T3U);
			      ci[WS(rs, 30)] = FMA(T3V, T3U, T3t * T46);
			      T4s = T4k + T4l;
			      T4u = T4o + T4p;
			      cr[WS(rs, 6)] = FNMS(T4t, T4u, T4r * T4s);
			      ci[WS(rs, 6)] = FMA(T4r, T4u, T4t * T4s);
			 }
			 {
			      E T4e, T4g, T4m, T4q;
			      T4e = T3E + T3T;
			      T4g = T42 + T45;
			      cr[WS(rs, 14)] = FNMS(T4f, T4g, T4d * T4e);
			      ci[WS(rs, 14)] = FMA(T4f, T4e, T4d * T4g);
			      T4m = T4k - T4l;
			      T4q = T4o - T4p;
			      cr[WS(rs, 22)] = FNMS(T4n, T4q, T4j * T4m);
			      ci[WS(rs, 22)] = FMA(T4j, T4q, T4n * T4m);
			 }
		    }
		    {
			 E T6I, T72, T6X, T73, T6P, T77, T6U, T76;
			 {
			      E T6G, T6H, T6V, T6W;
			      T6G = T56 + T5d;
			      T6H = T6h + T6i;
			      T6I = T6G + T6H;
			      T72 = T6G - T6H;
			      T6V = FMA(KP195090322, T6J, KP980785280 * T6K);
			      T6W = FNMS(KP195090322, T6M, KP980785280 * T6N);
			      T6X = T6V + T6W;
			      T73 = T6W - T6V;
			 }
			 {
			      E T6L, T6O, T6S, T6T;
			      T6L = FNMS(KP195090322, T6K, KP980785280 * T6J);
			      T6O = FMA(KP980785280, T6M, KP195090322 * T6N);
			      T6P = T6L + T6O;
			      T77 = T6L - T6O;
			      T6S = T6c + T6f;
			      T6T = T5s + T5l;
			      T6U = T6S + T6T;
			      T76 = T6S - T6T;
			 }
			 {
			      E T6Q, T6Y, T79, T7a;
			      T6Q = T6I - T6P;
			      T6Y = T6U - T6X;
			      cr[WS(rs, 17)] = FNMS(T6R, T6Y, T6F * T6Q);
			      ci[WS(rs, 17)] = FMA(T6R, T6Q, T6F * T6Y);
			      T79 = T72 + T73;
			      T7a = T76 + T77;
			      cr[WS(rs, 9)] = FNMS(T1d, T7a, T18 * T79);
			      ci[WS(rs, 9)] = FMA(T18, T7a, T1d * T79);
			 }
			 {
			      E T6Z, T70, T74, T78;
			      T6Z = T6I + T6P;
			      T70 = T6U + T6X;
			      cr[WS(rs, 1)] = FNMS(T14, T70, T11 * T6Z);
			      ci[WS(rs, 1)] = FMA(T14, T6Z, T11 * T70);
			      T74 = T72 - T73;
			      T78 = T76 - T77;
			      cr[WS(rs, 25)] = FNMS(T75, T78, T71 * T74);
			      ci[WS(rs, 25)] = FMA(T71, T78, T75 * T74);
			 }
		    }
		    {
			 E T84, T8q, T8l, T8r, T8b, T8v, T8i, T8u;
			 {
			      E T82, T83, T8j, T8k;
			      T82 = T7b + T7c;
			      T83 = T7F + T7G;
			      T84 = T82 - T83;
			      T8q = T82 + T83;
			      T8j = FMA(KP195090322, T86, KP980785280 * T85);
			      T8k = FMA(KP195090322, T89, KP980785280 * T88);
			      T8l = T8j - T8k;
			      T8r = T8j + T8k;
			 }
			 {
			      E T87, T8a, T8g, T8h;
			      T87 = FNMS(KP980785280, T86, KP195090322 * T85);
			      T8a = FNMS(KP980785280, T89, KP195090322 * T88);
			      T8b = T87 + T8a;
			      T8v = T87 - T8a;
			      T8g = T7C - T7D;
			      T8h = T7g - T7j;
			      T8i = T8g + T8h;
			      T8u = T8g - T8h;
			 }
			 {
			      E T8c, T8m, T8y, T8A;
			      T8c = T84 - T8b;
			      T8m = T8i - T8l;
			      cr[WS(rs, 23)] = FNMS(T8f, T8m, T81 * T8c);
			      ci[WS(rs, 23)] = FMA(T8f, T8c, T81 * T8m);
			      T8y = T8q + T8r;
			      T8A = T8u - T8v;
			      cr[WS(rs, 31)] = FNMS(T8z, T8A, T8x * T8y);
			      ci[WS(rs, 31)] = FMA(T8x, T8A, T8z * T8y);
			 }
			 {
			      E T8n, T8o, T8s, T8w;
			      T8n = T84 + T8b;
			      T8o = T8i + T8l;
			      cr[WS(rs, 7)] = FNMS(T1j, T8o, T1f * T8n);
			      ci[WS(rs, 7)] = FMA(T1j, T8n, T1f * T8o);
			      T8s = T8q - T8r;
			      T8w = T8u + T8v;
			      cr[WS(rs, 15)] = FNMS(T8t, T8w, T8p * T8s);
			      ci[WS(rs, 15)] = FMA(T8p, T8w, T8t * T8s);
			 }
		    }
		    {
			 E T5u, T6u, T6n, T6v, T67, T6B, T6k, T6A;
			 {
			      E T5e, T5t, T6l, T6m;
			      T5e = T56 - T5d;
			      T5t = T5l - T5s;
			      T5u = T5e + T5t;
			      T6u = T5e - T5t;
			      T6l = FMA(KP831469612, T5F, KP555570233 * T5M);
			      T6m = FNMS(KP831469612, T5Y, KP555570233 * T65);
			      T6n = T6l + T6m;
			      T6v = T6m - T6l;
			 }
			 {
			      E T5N, T66, T6g, T6j;
			      T5N = FNMS(KP831469612, T5M, KP555570233 * T5F);
			      T66 = FMA(KP555570233, T5Y, KP831469612 * T65);
			      T67 = T5N + T66;
			      T6B = T5N - T66;
			      T6g = T6c - T6f;
			      T6j = T6h - T6i;
			      T6k = T6g + T6j;
			      T6A = T6g - T6j;
			 }
			 {
			      E T68, T6o, T6D, T6E;
			      T68 = T5u - T67;
			      T6o = T6k - T6n;
			      cr[WS(rs, 21)] = FNMS(T69, T6o, T53 * T68);
			      ci[WS(rs, 21)] = FMA(T69, T68, T53 * T6o);
			      T6D = T6u + T6v;
			      T6E = T6A + T6B;
			      cr[WS(rs, 13)] = FNMS(T4c, T6E, T49 * T6D);
			      ci[WS(rs, 13)] = FMA(T49, T6E, T4c * T6D);
			 }
			 {
			      E T6p, T6q, T6w, T6C;
			      T6p = T5u + T67;
			      T6q = T6k + T6n;
			      cr[WS(rs, 5)] = FNMS(T4i, T6q, T4h * T6p);
			      ci[WS(rs, 5)] = FMA(T4i, T6p, T4h * T6q);
			      T6w = T6u - T6v;
			      T6C = T6A - T6B;
			      cr[WS(rs, 29)] = FNMS(T6z, T6C, T6t * T6w);
			      ci[WS(rs, 29)] = FMA(T6t, T6C, T6z * T6w);
			 }
		    }
		    {
			 E T7l, T7Q, T7L, T7R, T7A, T7V, T7I, T7U;
			 {
			      E T7d, T7k, T7J, T7K;
			      T7d = T7b - T7c;
			      T7k = T7g + T7j;
			      T7l = T7d - T7k;
			      T7Q = T7d + T7k;
			      T7J = FNMS(KP555570233, T7v, KP831469612 * T7y);
			      T7K = FMA(KP555570233, T7o, KP831469612 * T7r);
			      T7L = T7J - T7K;
			      T7R = T7J + T7K;
			 }
			 {
			      E T7s, T7z, T7E, T7H;
			      T7s = FNMS(KP555570233, T7r, KP831469612 * T7o);
			      T7z = FMA(KP831469612, T7v, KP555570233 * T7y);
			      T7A = T7s - T7z;
			      T7V = T7z + T7s;
			      T7E = T7C + T7D;
			      T7H = T7F - T7G;
			      T7I = T7E - T7H;
			      T7U = T7E + T7H;
			 }
			 {
			      E T7B, T7M, T7X, T7Y;
			      T7B = T7l - T7A;
			      T7M = T7I - T7L;
			      cr[WS(rs, 27)] = FNMS(T1k, T7M, T1g * T7B);
			      ci[WS(rs, 27)] = FMA(T1k, T7B, T1g * T7M);
			      T7X = T7Q + T7R;
			      T7Y = T7U + T7V;
			      cr[WS(rs, 3)] = FNMS(T15, T7Y, T12 * T7X);
			      ci[WS(rs, 3)] = FMA(T12, T7Y, T15 * T7X);
			 }
			 {
			      E T7N, T7O, T7S, T7W;
			      T7N = T7l + T7A;
			      T7O = T7I + T7L;
			      cr[WS(rs, 11)] = FNMS(T2Y, T7O, T2X * T7N);
			      ci[WS(rs, 11)] = FMA(T2Y, T7N, T2X * T7O);
			      T7S = T7Q - T7R;
			      T7W = T7U - T7V;
			      cr[WS(rs, 19)] = FNMS(T7T, T7W, T7P * T7S);
			      ci[WS(rs, 19)] = FMA(T7P, T7W, T7T * T7S);
			 }
		    }
	       }
	  }
     }
}

static const tw_instr twinstr[] = {
     {TW_CEXP, 1, 1},
     {TW_CEXP, 1, 3},
     {TW_CEXP, 1, 9},
     {TW_CEXP, 1, 27},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 32, "hb2_32", twinstr, &GENUS, {376, 168, 112, 0} };

void X(codelet_hb2_32) (planner *p) {
     X(khc2hc_register) (p, hb2_32, &desc);
}
#endif				/* HAVE_FMA */
